/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.tools;

import de.p2tools.p2lib.mediathek.tools.P2SizeTools;
import de.p2tools.p2podder.tools.MLBandwidthTokenBucket;
import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javafx.beans.property.IntegerProperty;

public class MLInputStream
extends InputStream {
    private final InputStream iStream;
    private MLBandwidthTokenBucket bucket = null;
    private final BandwidthCalculationTask calculationTask;

    public MLInputStream(InputStream in, Timer calculationTimer, IntegerProperty integerProperty) {
        this.iStream = in;
        this.bucket = new MLBandwidthTokenBucket(integerProperty);
        this.bucket.ensureBucketThreadIsRunning();
        this.calculationTask = new BandwidthCalculationTask();
        calculationTimer.scheduleAtFixedRate((TimerTask)this.calculationTask, 0L, 1000L);
    }

    @Override
    public void close() throws IOException {
        this.iStream.close();
        super.close();
        this.calculationTask.cancel();
    }

    @Override
    public int read() throws IOException {
        this.bucket.takeBlocking();
        int bytesRead = this.iStream.read();
        if (bytesRead != -1) {
            this.calculationTask.incrementBytesRead(1);
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.bucket.takeBlocking(b.length);
        int bytesRead = this.iStream.read(b);
        if (bytesRead != -1) {
            this.calculationTask.incrementBytesRead(bytesRead);
        }
        return bytesRead;
    }

    public long getBandwidth() {
        return this.calculationTask.getBandwidth();
    }

    public long getSumTime() {
        return this.calculationTask.getSumTime();
    }

    public long getSumByte() {
        return this.calculationTask.getTotalBytesRead();
    }

    public long getSumBandwidth() {
        long bytesRead = this.calculationTask.getTotalBytesRead();
        long time = this.calculationTask.getSumTime();
        return bytesRead <= 0L ? 0L : bytesRead / (time == 0L ? 1L : time);
    }

    public String toString() {
        long bytesRead = this.calculationTask.getTotalBytesRead();
        long b = this.getSumBandwidth();
        String s = P2SizeTools.humanReadableByteCount(bytesRead, true);
        return "Download: Bytes gelesen: " + s + "  Bandbreite: " + P2SizeTools.humanReadableByteCount(b, true);
    }

    public String[] getMsg() {
        long bytesRead = this.calculationTask.getTotalBytesRead();
        long b = this.getSumBandwidth();
        String s = P2SizeTools.humanReadableByteCount(bytesRead, true);
        return new String[]{"Download", "Bytes gelesen: " + s, "Bandbreite: " + P2SizeTools.humanReadableByteCount(b, true)};
    }

    private class BandwidthCalculationTask
    extends TimerTask {
        private long oldTotalBytes = 0L;
        private long totalBytesRead = 0L;
        private long bandwidth = 0L;
        private long sumTime = 0L;
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        private BandwidthCalculationTask() {
        }

        @Override
        public void run() {
            this.lock.writeLock().lock();
            this.bandwidth = this.totalBytesRead - this.oldTotalBytes;
            this.oldTotalBytes = this.totalBytesRead;
            ++this.sumTime;
            this.lock.writeLock().unlock();
        }

        public void incrementBytesRead(int value) {
            this.lock.writeLock().lock();
            this.totalBytesRead += (long)value;
            this.lock.writeLock().unlock();
        }

        public long getTotalBytesRead() {
            this.lock.readLock().lock();
            long res = this.totalBytesRead;
            this.lock.readLock().unlock();
            return res;
        }

        public long getBandwidth() {
            this.lock.readLock().lock();
            long bw = this.bandwidth;
            this.lock.readLock().unlock();
            return bw;
        }

        public long getSumTime() {
            this.lock.readLock().lock();
            long t = this.sumTime;
            this.lock.readLock().unlock();
            return t;
        }
    }
}

