/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.tools.table;

import de.p2tools.p2podder.controller.config.ProgColorList;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.controller.data.episode.EpisodeFactory;
import de.p2tools.p2podder.controller.data.episode.EpisodeProps;
import javafx.scene.control.TableRow;
import javafx.scene.control.Tooltip;

public class TableRowEpisode<T extends Episode>
extends TableRow<T> {
    @Override
    public void updateItem(T episode, boolean empty) {
        super.updateItem(episode, empty);
        if (episode == null || empty) {
            this.setStyle("");
            this.setTooltip(null);
        } else {
            if (((Episode)episode).getStart() != null && ((Episode)episode).getStart().getStartStatus().isStateError()) {
                Tooltip tooltip = new Tooltip();
                tooltip.setText(((Episode)episode).getStart().getStartStatus().getErrorMessage());
                this.setTooltip(tooltip);
            }
            boolean started = EpisodeFactory.episodeIsStarted(episode);
            boolean running = EpisodeFactory.episodeIsRunning(episode);
            boolean error = ((Episode)episode).getStart() != null && ((Episode)episode).getStart().getStartStatus().isStateError();
            boolean history = ProgData.getInstance().historyEpisodes.checkIfUrlAlreadyIn(((EpisodeProps)episode).getEpisodeUrl());
            if (((Episode)episode).getStart() != null && ((Episode)episode).getStart().getStartStatus().isStateError()) {
                Tooltip tooltip = new Tooltip();
                tooltip.setText(((Episode)episode).getStart().getStartStatus().getErrorMessage());
                this.setTooltip(tooltip);
            }
            if (error) {
                if (ProgColorList.EPISODE_ERROR_BG.isUse()) {
                    this.setStyle(ProgColorList.EPISODE_ERROR_BG.getCssBackground());
                } else {
                    this.setStyle("");
                }
            } else if (!started) {
                if (history) {
                    if (ProgColorList.EPISODE_HISTORY_BG.isUse()) {
                        this.setStyle(ProgColorList.EPISODE_HISTORY_BG.getCssBackground());
                    } else {
                        this.setStyle("");
                    }
                } else if (((Episode)episode).isNew()) {
                    if (ProgColorList.EPISODE_NEW_BG.isUse()) {
                        this.setStyle(ProgColorList.EPISODE_NEW_BG.getCssBackground());
                    } else {
                        this.setStyle("");
                    }
                } else {
                    this.setStyle("");
                }
            } else if (!running) {
                if (ProgColorList.EPISODE_STARTED_BG.isUse()) {
                    this.setStyle(ProgColorList.EPISODE_STARTED_BG.getCssBackground());
                } else {
                    this.setStyle("");
                }
            } else if (ProgColorList.EPISODE_RUNNING_BG.isUse()) {
                this.setStyle(ProgColorList.EPISODE_RUNNING_BG.getCssBackground());
            } else {
                this.setStyle("");
            }
        }
    }
}

