/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.tools.table;

import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2lib.tools.date.P2LDateTimeFactory;
import de.p2tools.p2lib.tools.file.P2FileSize;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgColorList;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.controller.data.episode.EpisodeFactory;
import de.p2tools.p2podder.gui.tools.table.Table;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;

public class TableEpisodeFactory {
    private TableEpisodeFactory() {
    }

    public static void columnFactoryString(TableColumn<Episode, String> column) {
        column.setCellFactory(c -> new TableCell<Episode, String>(){

            @Override
            protected void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                this.setText(item);
                Episode data = (Episode)this.getTableView().getItems().get(this.getIndex());
                TableEpisodeFactory.set(data, this);
            }
        });
    }

    public static void columnFactoryDuration(TableColumn<Episode, Integer> column) {
        column.setCellFactory(c -> new TableCell<Episode, Integer>(){

            @Override
            protected void updateItem(Integer item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                Episode data = (Episode)this.getTableView().getItems().get(this.getIndex());
                if (item == 0) {
                    this.setGraphic(null);
                    this.setText(null);
                } else {
                    this.setGraphic(null);
                    this.setText(data.getDurationStr());
                }
                TableEpisodeFactory.set(data, this);
            }
        });
    }

    public static void columnFactoryIntegerMax(TableColumn<Episode, Integer> column) {
        column.setCellFactory(c -> new TableCell<Episode, Integer>(){

            @Override
            protected void updateItem(Integer item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                if (item == Integer.MAX_VALUE) {
                    this.setGraphic(null);
                    this.setText(null);
                } else {
                    this.setGraphic(null);
                    this.setText("" + item);
                }
                Episode data = (Episode)this.getTableView().getItems().get(this.getIndex());
                TableEpisodeFactory.set(data, this);
            }
        });
    }

    public static void columnFactoryBoolean(TableColumn<Episode, Boolean> column) {
        column.setCellFactory(c -> new TableCell<Episode, Boolean>(){

            @Override
            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                this.setAlignment(Pos.CENTER);
                CheckBox box = new CheckBox();
                box.setMaxHeight(6.0);
                box.setMinHeight(6.0);
                box.setPrefSize(6.0, 6.0);
                box.setDisable(true);
                box.getStyleClass().add("checkbox-table");
                box.setSelected(item);
                this.setGraphic(box);
                Episode data = (Episode)this.getTableView().getItems().get(this.getIndex());
                TableEpisodeFactory.set(data, this);
            }
        });
    }

    public static void columnFactoryLocalDate(TableColumn<Episode, LocalDate> column) {
        column.setCellFactory(c -> new TableCell<Episode, LocalDate>(){

            @Override
            protected void updateItem(LocalDate item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                this.setText(P2LDateFactory.toString(item));
                Episode data = (Episode)this.getTableView().getItems().get(this.getIndex());
                TableEpisodeFactory.set(data, this);
            }
        });
    }

    public static void columnFactoryLocalDateTime(TableColumn<Episode, LocalDateTime> column) {
        column.setCellFactory(c -> new TableCell<Episode, LocalDateTime>(){

            @Override
            protected void updateItem(LocalDateTime item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                this.setText(P2LDateTimeFactory.toString(item));
                Episode data = (Episode)this.getTableView().getItems().get(this.getIndex());
                TableEpisodeFactory.set(data, this);
            }
        });
    }

    public static void columnFactoryP2FileSize(TableColumn<Episode, P2FileSize> column) {
        column.setCellFactory(c -> new TableCell<Episode, P2FileSize>(){

            @Override
            protected void updateItem(P2FileSize item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                this.setGraphic(null);
                this.setText(item.getSizeStr());
                Episode data = (Episode)this.getTableView().getItems().get(this.getIndex());
                TableEpisodeFactory.set(data, this);
            }
        });
    }

    public static void columnFactoryButton(TableColumn<Episode, String> column) {
        column.setCellFactory(c -> new TableCell<Episode, String>(){

            @Override
            protected void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                HBox hbox = new HBox();
                hbox.setSpacing(5.0);
                hbox.setAlignment(Pos.CENTER);
                hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
                Episode episode = (Episode)this.getTableView().getItems().get(this.getIndex());
                boolean started = EpisodeFactory.episodeIsStarted(episode);
                boolean running = EpisodeFactory.episodeIsRunning(episode);
                if (started || running) {
                    Button btnStop = new Button("");
                    btnStop.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnStop.setTooltip(new Tooltip("Episode stoppen"));
                    btnStop.setGraphic(ProgIcons.IMAGE_TABLE_STOP.getImageView());
                    btnStop.setOnAction(event -> {
                        EpisodeFactory.stopEpisode(episode);
                        this.getTableView().getSelectionModel().clearSelection();
                        this.getTableView().getSelectionModel().select(this.getIndex());
                    });
                    Table.setButtonSize(btnStop);
                    hbox.getChildren().add(btnStop);
                } else {
                    Button btnPlay = new Button("");
                    btnPlay.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnPlay.setTooltip(new Tooltip("Episode abspielen"));
                    btnPlay.setGraphic(ProgIcons.IMAGE_TABLE_PLAY.getImageView());
                    btnPlay.setOnAction(event -> {
                        EpisodeFactory.playEpisode(episode);
                        this.getTableView().getSelectionModel().clearSelection();
                        this.getTableView().getSelectionModel().select(this.getIndex());
                    });
                    Table.setButtonSize(btnPlay);
                    hbox.getChildren().add(btnPlay);
                }
                Button btnDel = new Button("");
                btnDel.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                btnDel.setTooltip(new Tooltip("Episode l\u00f6schen"));
                btnDel.setGraphic(ProgIcons.IMAGE_TABLE_DEL.getImageView());
                btnDel.setOnAction(event -> EpisodeFactory.delEpisode(episode));
                Table.setButtonSize(btnDel);
                hbox.getChildren().add(btnDel);
                this.setGraphic(hbox);
                TableEpisodeFactory.set(episode, this);
            }
        });
    }

    private static void set(Episode episode, TableCell tableCell) {
        boolean started = EpisodeFactory.episodeIsStarted(episode);
        boolean running = EpisodeFactory.episodeIsRunning(episode);
        boolean error = episode.getStart() != null ? episode.getStart().getStartStatus().isStateError() : false;
        boolean history = ProgData.getInstance().historyEpisodes.checkIfUrlAlreadyIn(episode.getEpisodeUrl());
        tableCell.setStyle("");
        if (error) {
            if (ProgColorList.EPISODE_ERROR.isUse()) {
                tableCell.setStyle(ProgColorList.EPISODE_ERROR.getCssFont());
            } else {
                tableCell.setStyle("");
            }
        } else if (!started) {
            if (!running && history) {
                if (ProgColorList.EPISODE_HISTORY.isUse()) {
                    tableCell.setStyle(ProgColorList.EPISODE_HISTORY.getCssFont());
                } else {
                    tableCell.setStyle("");
                }
            } else if (episode.isNew()) {
                if (ProgColorList.EPISODE_NEW.isUse()) {
                    tableCell.setStyle(ProgColorList.EPISODE_NEW.getCssFont());
                } else {
                    tableCell.setStyle("");
                }
            } else {
                tableCell.setStyle("");
            }
        } else if (!running) {
            if (ProgColorList.EPISODE_STARTED.isUse()) {
                tableCell.setStyle(ProgColorList.EPISODE_STARTED.getCssFont());
            } else {
                tableCell.setStyle("");
            }
        } else if (ProgColorList.EPISODE_RUNNING.isUse()) {
            tableCell.setStyle(ProgColorList.EPISODE_RUNNING.getCssFont());
        } else {
            tableCell.setStyle("");
        }
    }
}

