/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.tools.table;

import de.p2tools.p2lib.guitools.P2Open;
import de.p2tools.p2lib.mediathek.download.DownloadSizeData;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2lib.tools.date.P2LDateTimeFactory;
import de.p2tools.p2lib.tools.file.P2FileSize;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgColorList;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadConstants;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.controller.data.download.DownloadListStartStopFactory;
import de.p2tools.p2podder.gui.tools.table.Table;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.ProgressBarTableCell;
import javafx.scene.layout.HBox;

public class TableDownloadFactory {
    private TableDownloadFactory() {
    }

    public static void columnFactoryString(Table.TABLE_ENUM tableEnum, TableColumn<DownloadData, String> column) {
        column.setCellFactory(c -> new TableCell<DownloadData, String>(){

            @Override
            protected void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                this.setText(item);
                DownloadData data = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                TableDownloadFactory.set(data, this);
            }
        });
    }

    public static void columnFactoryProgress(Table.TABLE_ENUM tableEnum, TableColumn<DownloadData, Double> column) {
        column.setCellFactory(c -> new ProgressBarTableCell<DownloadData>(){

            @Override
            public void updateItem(Double item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                DownloadData data = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                if (item <= 0.001 || item >= 1.0) {
                    String text = DownloadConstants.getTextProgress(data.getState(), item);
                    Label label = new Label(text);
                    this.setGraphic(label);
                }
                TableDownloadFactory.set(data, this);
            }
        });
    }

    public static void columnFactoryDownloadSizeData(Table.TABLE_ENUM tableEnum, TableColumn<DownloadData, DownloadSizeData> column) {
        column.setCellFactory(c -> new TableCell<DownloadData, DownloadSizeData>(){

            @Override
            protected void updateItem(DownloadSizeData item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                this.setGraphic(null);
                this.setText(String.valueOf(item));
                DownloadData data = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                TableDownloadFactory.set(data, this);
            }
        });
    }

    public static void columnFactoryDuration(Table.TABLE_ENUM tableEnum, TableColumn<DownloadData, Integer> column) {
        column.setCellFactory(c -> new TableCell<DownloadData, Integer>(){

            @Override
            protected void updateItem(Integer item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                DownloadData data = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                if (item == 0) {
                    this.setGraphic(null);
                    this.setText(null);
                } else {
                    this.setGraphic(null);
                    this.setText(data.getDurationStr());
                }
                TableDownloadFactory.set(data, this);
            }
        });
    }

    public static void columnFactoryIntegerMax(Table.TABLE_ENUM tableEnum, TableColumn<DownloadData, Integer> column) {
        column.setCellFactory(c -> new TableCell<DownloadData, Integer>(){

            @Override
            protected void updateItem(Integer item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                if (item == Integer.MAX_VALUE) {
                    this.setGraphic(null);
                    this.setText(null);
                } else {
                    this.setGraphic(null);
                    this.setText("" + item);
                }
                DownloadData data = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                TableDownloadFactory.set(data, this);
            }
        });
    }

    public static void columnFactoryBoolean(Table.TABLE_ENUM tableEnum, TableColumn<DownloadData, Boolean> column) {
        column.setCellFactory(c -> new TableCell<DownloadData, Boolean>(){

            @Override
            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                this.setAlignment(Pos.CENTER);
                CheckBox box = new CheckBox();
                box.setMaxHeight(6.0);
                box.setMinHeight(6.0);
                box.setPrefSize(6.0, 6.0);
                box.setDisable(true);
                box.getStyleClass().add("checkbox-table");
                box.setSelected(item);
                this.setGraphic(box);
                DownloadData data = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                TableDownloadFactory.set(data, this);
            }
        });
    }

    public static void columnFactoryLocalDate(Table.TABLE_ENUM tableEnum, TableColumn<DownloadData, LocalDate> column) {
        column.setCellFactory(c -> new TableCell<DownloadData, LocalDate>(){

            @Override
            protected void updateItem(LocalDate item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                this.setText(P2LDateFactory.toString(item));
                DownloadData data = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                TableDownloadFactory.set(data, this);
            }
        });
    }

    public static void columnFactoryLocalDateTime(Table.TABLE_ENUM tableEnum, TableColumn<DownloadData, LocalDateTime> column) {
        column.setCellFactory(c -> new TableCell<DownloadData, LocalDateTime>(){

            @Override
            protected void updateItem(LocalDateTime item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                this.setText(P2LDateTimeFactory.toString(item));
                DownloadData data = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                TableDownloadFactory.set(data, this);
            }
        });
    }

    public static void columnFactoryP2FileSize(Table.TABLE_ENUM tableEnum, TableColumn<DownloadData, P2FileSize> column) {
        column.setCellFactory(c -> new TableCell<DownloadData, P2FileSize>(){

            @Override
            protected void updateItem(P2FileSize item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                this.setGraphic(null);
                this.setText(item.getSizeStr());
                DownloadData data = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                TableDownloadFactory.set(data, this);
            }
        });
    }

    public static void columnFactoryButton(Table.TABLE_ENUM tableEnum, TableColumn<DownloadData, Integer> column) {
        column.setCellFactory(c -> new TableCell<DownloadData, Integer>(){

            @Override
            protected void updateItem(Integer item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                HBox hbox = new HBox();
                hbox.setSpacing(5.0);
                hbox.setAlignment(Pos.CENTER);
                hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
                if (item <= 1) {
                    Button btnDownStart = new Button("");
                    btnDownStart.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnDownStart.setTooltip(new Tooltip("Download starten"));
                    btnDownStart.setGraphic(ProgIcons.IMAGE_TABLE_DOWNLOAD_START.getImageView());
                    btnDownStart.setOnAction(event -> {
                        DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                        ProgData.getInstance().downloadList.startDownloads(download);
                    });
                    Button btnDownBack = new Button("");
                    btnDownBack.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnDownBack.setTooltip(new Tooltip("Download zur\u00fcckstellen, beim n\u00e4chsten Suchen wieder anzeigen"));
                    btnDownBack.setGraphic(ProgIcons.IMAGE_TABLE_BACK.getImageView());
                    btnDownBack.setOnAction(event -> {
                        DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                        ProgData.getInstance().downloadList.putBackDownloads(download);
                    });
                    Button btnDownDel = new Button("");
                    btnDownDel.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnDownDel.setTooltip(new Tooltip("Download dauerhaft l\u00f6schen, Pod als geh\u00f6rt markieren"));
                    btnDownDel.setGraphic(ProgIcons.IMAGE_TABLE_DEL.getImageView());
                    btnDownDel.setOnAction(event -> {
                        DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                        DownloadListStartStopFactory.delDownloads(download);
                    });
                    Table.setButtonSize(btnDownStart);
                    Table.setButtonSize(btnDownBack);
                    Table.setButtonSize(btnDownDel);
                    hbox.getChildren().addAll((Node[])new Node[]{btnDownStart, btnDownBack, btnDownDel});
                    this.setGraphic(hbox);
                } else if (item < 4) {
                    Button btnDownStop = new Button("");
                    btnDownStop.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnDownStop.setTooltip(new Tooltip("Download stoppen"));
                    btnDownStop.setGraphic(ProgIcons.IMAGE_TABLE_STOP.getImageView());
                    btnDownStop.setOnAction(event -> {
                        DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                        download.stopDownload();
                    });
                    Button btnDownDel = new Button("");
                    btnDownDel.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnDownDel.setTooltip(new Tooltip("Download dauerhaft l\u00f6schen, Pod als geh\u00f6rt markieren"));
                    btnDownDel.setGraphic(ProgIcons.IMAGE_TABLE_DEL.getImageView());
                    btnDownDel.setOnAction(event -> {
                        DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                        DownloadListStartStopFactory.delDownloads(download);
                    });
                    Table.setButtonSize(btnDownStop);
                    Table.setButtonSize(btnDownDel);
                    hbox.getChildren().addAll((Node[])new Node[]{btnDownStop, btnDownDel});
                    this.setGraphic(hbox);
                } else if (item == 4) {
                    Button btnOpenDirectory = new Button();
                    btnOpenDirectory.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnOpenDirectory.setTooltip(new Tooltip("Ordner mit gespeichertem Film \u00f6ffnen"));
                    btnOpenDirectory.setGraphic(ProgIcons.IMAGE_TABLE_FILE_OPEN.getImageView());
                    btnOpenDirectory.setOnAction(event -> {
                        DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                        P2Open.openDir(download.getDestPath(), ProgConfig.SYSTEM_PROG_OPEN_DIR, ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
                    });
                    Table.setButtonSize(btnOpenDirectory);
                    hbox.getChildren().addAll((Node[])new Node[]{btnOpenDirectory});
                    this.setGraphic(hbox);
                } else if (item == 5) {
                    Button btnDownStart = new Button("");
                    btnDownStart.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnDownStart.setTooltip(new Tooltip("Download wider starten"));
                    btnDownStart.setGraphic(ProgIcons.IMAGE_TABLE_DOWNLOAD_START.getImageView());
                    btnDownStart.setOnAction(event -> {
                        DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                        ArrayList<DownloadData> list = new ArrayList<DownloadData>();
                        list.add(download);
                        ProgData.getInstance().downloadList.startDownloads(list, true);
                    });
                    Button btnDownDel = new Button("");
                    btnDownDel.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnDownDel.setTooltip(new Tooltip("Download dauerhaft l\u00f6schen, Pod als geh\u00f6rt markieren"));
                    btnDownDel.setGraphic(ProgIcons.IMAGE_TABLE_DEL.getImageView());
                    btnDownDel.setOnAction(event -> {
                        DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                        DownloadListStartStopFactory.delDownloads(download);
                    });
                    Table.setButtonSize(btnDownStart);
                    Table.setButtonSize(btnDownDel);
                    hbox.getChildren().addAll((Node[])new Node[]{btnDownStart, btnDownDel});
                    this.setGraphic(hbox);
                } else {
                    this.setGraphic(null);
                    this.setText(null);
                }
                DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                TableDownloadFactory.set(download, this);
            }
        });
    }

    private static void set(DownloadData download, TableCell tableCell) {
        switch (download.getState()) {
            case 2: {
                if (ProgColorList.DOWNLOAD_WAIT.isUse()) {
                    tableCell.setStyle(ProgColorList.DOWNLOAD_WAIT.getCssFont());
                    break;
                }
                tableCell.setStyle("");
                break;
            }
            case 3: {
                if (ProgColorList.DOWNLOAD_RUN.isUse()) {
                    tableCell.setStyle(ProgColorList.DOWNLOAD_RUN.getCssFont());
                    break;
                }
                tableCell.setStyle("");
                break;
            }
            case 4: {
                if (ProgColorList.DOWNLOAD_FINISHED.isUse()) {
                    tableCell.setStyle(ProgColorList.DOWNLOAD_FINISHED.getCssFont());
                    break;
                }
                tableCell.setStyle("");
                break;
            }
            case 5: {
                if (ProgColorList.DOWNLOAD_ERROR.isUse()) {
                    tableCell.setStyle(ProgColorList.DOWNLOAD_ERROR.getCssFont());
                    break;
                }
                tableCell.setStyle("");
                break;
            }
            default: {
                tableCell.setStyle("");
            }
        }
    }
}

