/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.tools.table;

import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.controller.data.episode.EpisodeFactory;
import de.p2tools.p2podder.gui.tools.table.Table;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.util.Callback;

public class CellSmallEpisodeButton<S, T>
extends TableCell<S, T> {
    public final Callback<TableColumn<Episode, Integer>, TableCell<Episode, Integer>> cellFactory = param -> {
        TableCell<Episode, Integer> cell = new TableCell<Episode, Integer>(){

            @Override
            public void updateItem(Integer item, boolean empty) {
                boolean error;
                super.updateItem(item, empty);
                if (empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                HBox hbox = new HBox();
                hbox.setSpacing(5.0);
                hbox.setAlignment(Pos.CENTER);
                hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
                Episode episode = (Episode)this.getTableView().getItems().get(this.getIndex());
                boolean started = EpisodeFactory.episodeIsStarted(episode);
                boolean running = EpisodeFactory.episodeIsRunning(episode);
                boolean bl = error = episode.getStart() != null ? episode.getStart().getStartStatus().isStateError() : false;
                if (started || running) {
                    Button btnStop = new Button("");
                    btnStop.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnStop.setTooltip(new Tooltip("Episode stoppen"));
                    btnStop.setGraphic(ProgIcons.IMAGE_TABLE_STOP.getImageView());
                    btnStop.setOnAction(event -> {
                        EpisodeFactory.stopEpisode(episode);
                        this.getTableView().getSelectionModel().clearSelection();
                        this.getTableView().getSelectionModel().select(this.getIndex());
                    });
                    Table.setButtonSize(btnStop);
                    hbox.getChildren().add(btnStop);
                } else {
                    Button btnPlay = new Button("");
                    btnPlay.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                    btnPlay.setTooltip(new Tooltip("Episode abspielen"));
                    btnPlay.setGraphic(ProgIcons.IMAGE_TABLE_PLAY.getImageView());
                    btnPlay.setOnAction(event -> {
                        EpisodeFactory.playEpisode(episode);
                        this.getTableView().getSelectionModel().clearSelection();
                        this.getTableView().getSelectionModel().select(this.getIndex());
                    });
                    Table.setButtonSize(btnPlay);
                    hbox.getChildren().add(btnPlay);
                }
                Button btnDel = new Button("");
                btnDel.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                btnDel.setTooltip(new Tooltip("Episode l\u00f6schen"));
                btnDel.setGraphic(ProgIcons.IMAGE_TABLE_DEL.getImageView());
                btnDel.setOnAction(event -> EpisodeFactory.delEpisode(episode));
                Table.setButtonSize(btnDel);
                hbox.getChildren().add(btnDel);
                this.setGraphic(hbox);
            }
        };
        return cell;
    };
}

