/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.tools.table;

import de.p2tools.p2podder.controller.data.download.DownloadConstants;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.ProgressBarTableCell;
import javafx.util.Callback;

public class CellProgress<S, T>
extends TableCell<S, T> {
    public final Callback<TableColumn<DownloadData, Double>, TableCell<DownloadData, Double>> cellFactory = param -> {
        ProgressBarTableCell<DownloadData> cell = new ProgressBarTableCell<DownloadData>(){

            @Override
            public void updateItem(Double item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                if (item != null) {
                    DownloadData download = (DownloadData)this.getTableView().getItems().get(this.getIndex());
                    if (item <= 0.001 || item >= 1.0) {
                        String text = DownloadConstants.getTextProgress(download.getState(), item);
                        Label label = new Label(text);
                        this.setGraphic(label);
                    }
                }
            }
        };
        return cell;
    };
}

