/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.tools.table;

import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import de.p2tools.p2podder.controller.parser.ParserThread;
import de.p2tools.p2podder.gui.tools.table.Table;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.util.Callback;

public class CellPodcastButton<S, T>
extends TableCell<S, T> {
    public final Callback<TableColumn<Podcast, Integer>, TableCell<Podcast, Integer>> cellFactory = param -> {
        TableCell<Podcast, Integer> cell = new TableCell<Podcast, Integer>(){

            @Override
            public void updateItem(Integer item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                Podcast podcast = (Podcast)this.getTableView().getItems().get(this.getIndex());
                Button btnUpdate = new Button("");
                btnUpdate.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                btnUpdate.setTooltip(new Tooltip("Podcast aktualisieren"));
                btnUpdate.setGraphic(ProgIcons.IMAGE_TABLE_UPDATE.getImageView());
                btnUpdate.setOnAction(event -> new ParserThread(ProgData.getInstance()).parse(podcast));
                Button btnDel = new Button("");
                btnDel.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                btnDel.setTooltip(new Tooltip("Podcast l\u00f6schen"));
                btnDel.setGraphic(ProgIcons.IMAGE_TABLE_DEL.getImageView());
                btnDel.setOnAction(event -> ProgData.getInstance().podcastList.removePodcast(podcast));
                Button btnActive = new Button("");
                btnActive.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncTable"});
                btnActive.setTooltip(new Tooltip("Podcast ein-/ausschalten"));
                btnActive.setGraphic(ProgIcons.IMAGE_TABLE_OFF.getImageView());
                btnActive.setOnAction(event -> ProgData.getInstance().worker.setPodcastActive(podcast));
                Table.setButtonSize(btnUpdate);
                Table.setButtonSize(btnDel);
                Table.setButtonSize(btnActive);
                HBox hbox = new HBox();
                hbox.setSpacing(5.0);
                hbox.setAlignment(Pos.CENTER);
                hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
                hbox.getChildren().addAll((Node[])new Node[]{btnUpdate, btnDel, btnActive});
                this.setGraphic(hbox);
            }
        };
        return cell;
    };
}

