/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.tools;

import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.tools.P2InfoFactory;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.ProgQuitFactory;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.EpisodeFactory;
import de.p2tools.p2podder.gui.configdialog.ConfigDialogController;
import de.p2tools.p2podder.gui.dialog.AboutDialogController;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Arrays;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.stage.Stage;

public class ProgTray {
    private final ProgData progData;
    private SystemTray systemTray = null;

    public ProgTray(ProgData progData) {
        this.progData = progData;
    }

    public void initProgTray() {
        ProgConfig.SYSTEM_TRAY.addListener((observableValue, aBoolean, t1) -> Platform.runLater(() -> this.setTray()));
        ProgConfig.SYSTEM_TRAY_USE_OWN_ICON.addListener((observableValue, aBoolean, t1) -> Platform.runLater(() -> this.setTray()));
        ProgConfig.SYSTEM_TRAY_ICON_PATH.addListener((observableValue, aBoolean, t1) -> Platform.runLater(() -> this.setTray()));
        this.setTray();
    }

    private void removeTray() {
        if (this.systemTray != null) {
            ((Stream)Arrays.stream(this.systemTray.getTrayIcons()).sequential()).forEach(e -> this.systemTray.remove((TrayIcon)e));
            this.systemTray = null;
        }
    }

    private void setTray() {
        if (!SystemTray.isSupported()) {
            return;
        }
        if (!ProgConfig.SYSTEM_TRAY.get()) {
            this.removeTray();
            return;
        }
        if (this.systemTray == null) {
            this.systemTray = SystemTray.getSystemTray();
        }
        this.setIcon();
    }

    private void setIcon() {
        Image image;
        if (this.systemTray == null) {
            return;
        }
        for (TrayIcon tr : this.systemTray.getTrayIcons()) {
            this.systemTray.remove(tr);
        }
        if (ProgConfig.SYSTEM_TRAY_USE_OWN_ICON.getValue().booleanValue() && !ProgConfig.SYSTEM_TRAY_ICON_PATH.getValueSafe().isEmpty()) {
            resource = ProgConfig.SYSTEM_TRAY_ICON_PATH.getValueSafe();
            image = Toolkit.getDefaultToolkit().getImage(resource);
        } else {
            resource = "de/p2tools/p2podder/res/P2_24.png";
            URL res = ClassLoader.getSystemResource(resource);
            image = Toolkit.getDefaultToolkit().getImage(res);
        }
        TrayIcon trayicon = new TrayIcon(image, "MTPlayer");
        this.addMenu(trayicon);
        trayicon.setImageAutoSize(true);
        trayicon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    ProgTray.this.maxMin();
                }
            }
        });
        try {
            this.systemTray.add(trayicon);
        }
        catch (AWTException exception) {
            P2Log.errorLog(912547030, exception.getMessage());
        }
    }

    private void addMenu(TrayIcon trayicon) {
        MenuItem miMaxMin = new MenuItem("Programm maximieren/minimieren");
        MenuItem miStop = new MenuItem("alle laufenden Episoden stoppen");
        MenuItem miInfo = new MenuItem("Episoden-Info-Dialog \u00f6ffnen");
        MenuItem miConfig = new MenuItem("Einstellungen \u00f6ffnen");
        MenuItem miTray = new MenuItem("Tray-Icon ausblenden");
        MenuItem miAbout = new MenuItem("\u00fcber dieses Programm");
        MenuItem miQuit = new MenuItem("Programm Beenden");
        miMaxMin.addActionListener(e -> Platform.runLater(() -> this.maxMin()));
        miStop.addActionListener(e -> this.progData.episodeList.stream().forEach(f -> EpisodeFactory.stopEpisode(f)));
        miInfo.addActionListener(e -> Platform.runLater(() -> this.progData.episodeInfoDialogController.toggleShowInfo()));
        miConfig.addActionListener(e -> Platform.runLater(() -> new ConfigDialogController(this.progData)));
        miTray.addActionListener(e -> Platform.runLater(() -> this.closeTray()));
        miAbout.addActionListener(e -> Platform.runLater(() -> new AboutDialogController(this.progData).showDialog()));
        miQuit.addActionListener(e -> Platform.runLater(() -> {
            Stage stage = null;
            if (this.progData.smallGuiPack != null) {
                stage = this.progData.smallGuiPack.getStage();
            } else if (this.progData.primaryStage.isShowing()) {
                stage = this.progData.primaryStage;
            }
            ProgQuitFactory.quit();
        }));
        PopupMenu popupMenu = new PopupMenu();
        popupMenu.add(miMaxMin);
        popupMenu.add(miStop);
        popupMenu.add(miInfo);
        popupMenu.add(miConfig);
        if (!P2InfoFactory.getOs().equals((Object)P2InfoFactory.OperatingSystemType.MAC)) {
            popupMenu.add(miTray);
        }
        popupMenu.addSeparator();
        popupMenu.add(miAbout);
        if (!P2InfoFactory.getOs().equals((Object)P2InfoFactory.OperatingSystemType.MAC)) {
            popupMenu.addSeparator();
            popupMenu.add(miQuit);
        }
        trayicon.setPopupMenu(popupMenu);
    }

    private void closeTray() {
        this.showDialog();
        ProgConfig.SYSTEM_TRAY.setValue(false);
    }

    private synchronized void maxMin() {
        if (this.progData.primaryStage.isShowing()) {
            this.hideDialog();
        } else {
            this.showDialog();
        }
    }

    private void hideDialog() {
        Platform.runLater(() -> this.progData.primaryStage.hide());
        P2DialogExtra.hideAllDialog();
    }

    private void showDialog() {
        Platform.runLater(() -> this.progData.primaryStage.show());
        P2DialogExtra.showAllDialog();
    }
}

