/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.startdialog;

import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2Hyperlink;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgColorList;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.config.ProgInfosFactory;
import de.p2tools.p2podder.controller.data.SetFactory;
import de.p2tools.p2podder.gui.tools.HelpText;
import java.io.File;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class ConfigPane {
    private final Stage stage;
    private final P2ToggleSwitch tglSearch = new P2ToggleSwitch("einmal am Tag nach einer neuen Programmversion suchen");
    private final GridPane gridPane = new GridPane();
    private final TextField txtPlayer = new TextField();
    private TextField txtPodDest = new TextField();
    private int row = 0;

    public ConfigPane(Stage stage) {
        this.stage = stage;
    }

    public TitledPane makeStart() {
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        this.gridPane.setPadding(new Insets(10.0));
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        this.makeDestPath();
        this.makeVLCPath();
        this.makeUpdate();
        TitledPane tpConfig = new TitledPane("Programmeinstellungen", this.gridPane);
        return tpConfig;
    }

    public void close() {
        this.tglSearch.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_SEARCH_UPDATE);
        this.txtPlayer.textProperty().bindBidirectional(ProgConfig.SYSTEM_PATH_VLC);
    }

    private void makeDestPath() {
        Text text = new Text("Einen Ordner zum Speichern der Episoden ausw\u00e4hlen");
        text.setStyle("-fx-font-weight: bold");
        this.gridPane.add(new Label(" "), 2, this.row);
        this.gridPane.add(text, 0, this.row);
        Button btnHelp = P2Button.helpButton(this.stage, "Speicherordner Episoden", HelpText.DEST_DIR_EPISODES);
        if (ProgData.debug) {
            ProgConfig.SYSTEM_POD_DIR.setValue("/tmp/Podcast");
        }
        this.txtPodDest.textProperty().bindBidirectional(ProgConfig.SYSTEM_POD_DIR);
        if (ProgData.debug) {
            ProgConfig.SYSTEM_POD_DIR.setValue("/tmp/Download");
        }
        if (this.txtPodDest.getText().isEmpty()) {
            this.txtPodDest.setText(ProgInfosFactory.getStandardPodDestString());
        }
        Button btnFile = new Button();
        btnFile.setTooltip(new Tooltip("Einen Ordner f\u00fcr die Episoden ausw\u00e4hlen"));
        btnFile.setOnAction(event -> P2DirFileChooser.DirChooser(ProgData.getInstance().primaryStage, this.txtPodDest));
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        Button btnReset = new Button();
        btnReset.setGraphic(ProgIcons.ICON_BUTTON_PROPOSE.getImageView());
        btnReset.setTooltip(new Tooltip("Standardpfad f\u00fcr die Episoden wieder herstellen"));
        btnReset.setOnAction(event -> this.txtPodDest.setText(ProgInfosFactory.getStandardPodDestString()));
        this.gridPane.add(this.txtPodDest, 0, ++this.row);
        this.gridPane.add(btnFile, 1, this.row);
        this.gridPane.add(btnReset, 2, this.row);
        this.gridPane.add(btnHelp, 3, this.row);
        GridPane.setHalignment(btnReset, HPos.RIGHT);
    }

    private void makeVLCPath() {
        Text text = new Text("Pfad zum Media-Player ausw\u00e4hlen");
        text.setStyle("-fx-font-weight: bold");
        P2Hyperlink hyperlink = new P2Hyperlink(this.stage, "http://www.videolan.org", ProgConfig.SYSTEM_PROG_OPEN_URL);
        Button btnFind = new Button("suchen");
        btnFind.setOnAction(event -> {
            ProgConfig.SYSTEM_PATH_VLC.setValue("");
            this.txtPlayer.setText(SetFactory.getTemplatePathVlc());
        });
        this.txtPlayer.textProperty().addListener((observable2, oldValue, newValue) -> {
            File file = new File(this.txtPlayer.getText());
            if (!file.exists() || !file.isFile()) {
                this.txtPlayer.setStyle(ProgColorList.EPISODE_ERROR_BG.getCssBackground());
            } else {
                this.txtPlayer.setStyle("");
            }
        });
        this.txtPlayer.textProperty().bindBidirectional(ProgConfig.SYSTEM_PATH_VLC);
        Button btnFile = new Button();
        btnFile.setOnAction(event -> P2DirFileChooser.FileChooserOpenFile(this.stage, this.txtPlayer));
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        btnFile.setTooltip(new Tooltip("Programmdatei ausw\u00e4hlen"));
        Button btnHelp = P2Button.helpButton(this.stage, "Videoplayer", HelpText.PROG_PATHS);
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.getChildren().addAll((Node[])new Node[]{new Label("Website"), hyperlink});
        this.gridPane.add(new Label(" "), 2, ++this.row);
        this.gridPane.add(text, 0, ++this.row);
        this.gridPane.add(this.txtPlayer, 0, ++this.row);
        this.gridPane.add(btnFile, 1, this.row);
        this.gridPane.add(btnFind, 2, this.row);
        GridPane.setHalignment(btnFind, HPos.RIGHT);
        this.gridPane.add(btnHelp, 3, this.row);
        this.gridPane.add(hBox, 0, ++this.row, 3, 1);
    }

    private void makeUpdate() {
        this.tglSearch.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_SEARCH_UPDATE);
        Text text = new Text("Suche nach einem Programmupdate");
        text.setStyle("-fx-font-weight: bold");
        Button btnHelp = P2Button.helpButton(this.stage, "Programmupdate suchen", "Beim Programmstart wird gepr\u00fcft, ob es eine neue Version des Programms gibt. Wenn es eine neue Version gibt, wird das mit einer Nachricht mitgeteilt. Es wird nicht automatisch das Programm ver\u00e4ndert.");
        this.gridPane.add(new Label(" "), 2, ++this.row);
        this.gridPane.add(text, 0, ++this.row);
        this.gridPane.add(this.tglSearch, 0, ++this.row, 3, 1);
        GridPane.setHalignment(this.tglSearch, HPos.RIGHT);
        this.gridPane.add(btnHelp, 3, this.row);
    }
}

