/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.smallgui;

import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.controller.data.episode.EpisodeFactory;
import de.p2tools.p2podder.gui.smallgui.SmallGuiCenter;
import de.p2tools.p2podder.gui.tools.table.TableSmallEpisode;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;

public class SmallGuiTableContextMenu {
    private final ProgData progData;
    private final SmallGuiCenter episodeGuiController;
    private final TableSmallEpisode tableView;

    public SmallGuiTableContextMenu(ProgData progData, SmallGuiCenter episodeGuiController, TableSmallEpisode tableView) {
        this.progData = progData;
        this.episodeGuiController = episodeGuiController;
        this.tableView = tableView;
    }

    public ContextMenu getContextMenu(Episode episode) {
        ContextMenu contextMenu = new ContextMenu();
        this.getMenu(contextMenu, episode);
        return contextMenu;
    }

    private void getMenu(ContextMenu contextMenu, Episode episode) {
        MenuItem miStart = new MenuItem("Episode abspielen");
        miStart.setOnAction(a -> EpisodeFactory.playEpisode(episode));
        MenuItem miStop = new MenuItem("Episode stoppen");
        miStop.setOnAction(a -> EpisodeFactory.stopEpisode(episode));
        MenuItem miStopAll = new MenuItem("alle Episoden stoppen");
        miStopAll.setOnAction(a -> EpisodeFactory.stopAllEpisode());
        MenuItem miCopyUrl = new MenuItem("Episode (URL) kopieren");
        miCopyUrl.setOnAction(a -> EpisodeFactory.copyUrl());
        MenuItem miChange = new MenuItem("Episode \u00e4ndern");
        miChange.setOnAction(a -> this.progData.episodeInfoDialogController.toggleShowInfo());
        MenuItem miRemove = new MenuItem("Episode l\u00f6schen");
        miRemove.setOnAction(a -> EpisodeFactory.delEpisode());
        miStart.setDisable(episode == null);
        miStop.setDisable(episode == null);
        miStopAll.setDisable(episode == null);
        miCopyUrl.setDisable(episode == null);
        miChange.setDisable(episode == null);
        miRemove.setDisable(episode == null);
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miStart, miStop, miStopAll, miCopyUrl, miChange, miRemove});
        MenuItem resetTable = new MenuItem("Tabelle zur\u00fccksetzen");
        resetTable.setOnAction(a -> this.tableView.resetTable());
        contextMenu.getItems().add(new SeparatorMenuItem());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{resetTable});
    }
}

