/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.filter;

import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.filter.FilterCheckRegEx;
import java.util.Collection;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class PodcastFilterController
extends VBox {
    private final ComboBox<String> cboGenre = new ComboBox();
    private final TextField txtName = new TextField();
    private final TextField txtUrl = new TextField();
    private ProgData progData = ProgData.getInstance();

    public PodcastFilterController() {
        VBox vBoxTxt = new VBox();
        vBoxTxt.getChildren().addAll((Node[])new Node[]{new Label("Name:"), this.txtName});
        vBoxTxt.getChildren().addAll((Node[])new Node[]{new Label("URL:"), this.txtUrl});
        VBox vBoxGenre = new VBox();
        this.cboGenre.setMaxWidth(Double.MAX_VALUE);
        vBoxGenre.getChildren().addAll((Node[])new Node[]{new Label("Genre: "), this.cboGenre});
        VBox.setVgrow(this, Priority.ALWAYS);
        this.setPadding(new Insets(10.0));
        this.setSpacing(5.0);
        this.getChildren().addAll((Node[])new Node[]{vBoxGenre, vBoxTxt, P2GuiTools.getVBoxGrower()});
        this.addButton();
        this.initFilter();
    }

    private void addButton() {
        Button btnClearFilter = new Button("");
        btnClearFilter.setGraphic(ProgIcons.ICON_BUTTON_CLEAR_FILTER.getImageView());
        btnClearFilter.setOnAction(a -> this.progData.podcastFilter.clearFilter());
        btnClearFilter.setTooltip(new Tooltip("Alle Filter l\u00f6schen"));
        HBox hBoxAll = new HBox(5.0);
        hBoxAll.setAlignment(Pos.CENTER_RIGHT);
        HBox.setHgrow(hBoxAll, Priority.ALWAYS);
        hBoxAll.getChildren().addAll((Node[])new Node[]{btnClearFilter});
        Separator separator = new Separator();
        separator.getStyleClass().add("pseperator2");
        this.getChildren().addAll((Node[])new Node[]{P2GuiTools.getHDistance(10), separator, hBoxAll});
    }

    private void initFilter() {
        this.cboGenre.getItems().addAll((Collection<String>)this.progData.podcastList.getGenreList());
        this.progData.podcastList.getGenreList().addListener(change -> Platform.runLater(() -> {
            String sel = (String)this.cboGenre.getSelectionModel().getSelectedItem();
            this.cboGenre.getItems().setAll((Collection<String>)this.progData.podcastList.getGenreList());
            if (this.cboGenre.getItems().contains(sel)) {
                this.cboGenre.getSelectionModel().select(sel);
            } else {
                this.progData.podcastFilter.clearFilter();
            }
        }));
        this.cboGenre.valueProperty().bindBidirectional(this.progData.podcastFilter.genreProperty());
        this.txtName.textProperty().bindBidirectional(this.progData.podcastFilter.nameProperty());
        FilterCheckRegEx fName = new FilterCheckRegEx(this.txtName);
        this.txtName.textProperty().addListener((observable2, oldValue, newValue) -> fName.checkPattern());
        this.txtUrl.textProperty().bindBidirectional(this.progData.podcastFilter.urlProperty());
        FilterCheckRegEx fUrl = new FilterCheckRegEx(this.txtUrl);
        this.txtUrl.textProperty().addListener((observable2, oldValue, newValue) -> fUrl.checkPattern());
    }
}

