/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.filter;

import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.guitools.prange.P2RangeBox;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.EpisodeFactory;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import de.p2tools.p2podder.controller.filter.FilterCheckRegEx;
import de.p2tools.p2podder.gui.filter.EpisodeFilterControllerClearFilter;
import java.util.Collection;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.Slider;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class EpisodeFilterController
extends VBox {
    private final ScrollPane scrollPane = new ScrollPane();
    private final TableView<Podcast> tableView = new TableView();
    private final ComboBox<String> cboGenre = new ComboBox();
    private final TextField txtTitle = new TextField();
    private final TextField txtDescription = new TextField();
    private final ProgData progData;
    private final P2RangeBox slDur = new P2RangeBox("L\u00e4nge:", true, 0, 100);
    private final Slider slTimeRange = new Slider();
    private final Label lblTimeRangeValue = new Label();
    private final Callback<TableColumn<Podcast, String>, TableCell<Podcast, String>> cellFactory = param -> {
        TableCell<Podcast, String> cell = new TableCell<Podcast, String>(){

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                VBox vBox = new VBox();
                vBox.setSpacing(5.0);
                vBox.setAlignment(Pos.CENTER_LEFT);
                vBox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
                Podcast podcast = (Podcast)this.getTableView().getItems().get(this.getIndex());
                String name = podcast.getName();
                String genre = podcast.getGenre();
                String count = "" + EpisodeFactory.countEpisode(podcast);
                Label lblCount = new Label(count);
                Label lblName = new Label(name);
                Label lblGenre = new Label(genre);
                lblCount.getStyleClass().add("lblCount");
                lblCount.setMinWidth(Double.NEGATIVE_INFINITY);
                VBox vBox1 = new VBox();
                vBox1.getChildren().addAll((Node[])new Node[]{lblName, lblGenre});
                HBox hBox = new HBox();
                hBox.setSpacing(10.0);
                hBox.setAlignment(Pos.CENTER_LEFT);
                hBox.getChildren().addAll((Node[])new Node[]{lblCount, vBox1});
                vBox.getChildren().add(hBox);
                this.setGraphic(vBox);
            }
        };
        return cell;
    };

    public EpisodeFilterController() {
        this.progData = ProgData.getInstance();
        VBox vBoxTimeRange = new VBox(2.0);
        HBox h = new HBox();
        HBox hh = new HBox();
        Label lblTimeRange = new Label("Zeitraum:");
        h.getChildren().addAll((Node[])new Node[]{lblTimeRange, hh, this.lblTimeRangeValue});
        HBox.setHgrow(hh, Priority.ALWAYS);
        lblTimeRange.setMinWidth(0.0);
        vBoxTimeRange.getChildren().addAll((Node[])new Node[]{h, this.slTimeRange});
        VBox vBoxGenre = new VBox();
        this.cboGenre.setMaxWidth(Double.MAX_VALUE);
        vBoxGenre.getChildren().addAll((Node[])new Node[]{new Label("Genre: "), this.cboGenre});
        VBox vBoxTxt = new VBox();
        vBoxTxt.getChildren().addAll((Node[])new Node[]{new Label("Titel:"), this.txtTitle});
        vBoxTxt.getChildren().addAll((Node[])new Node[]{new Label("Beschreibung:"), this.txtDescription});
        VBox.setVgrow(this, Priority.ALWAYS);
        this.setPadding(new Insets(10.0));
        this.setSpacing(5.0);
        this.getChildren().addAll((Node[])new Node[]{this.scrollPane, vBoxGenre, vBoxTxt, vBoxTimeRange, this.slDur, P2GuiTools.getVBoxGrower()});
        Separator separator = new Separator();
        separator.getStyleClass().add("pseperator2");
        this.getChildren().addAll((Node[])new Node[]{P2GuiTools.getHDistance(10), separator, new EpisodeFilterControllerClearFilter()});
        this.initDurFilter();
        this.initDaysFilter();
        this.initTable();
        this.initFilter();
    }

    private void initDurFilter() {
        this.slDur.minValueProperty().set(this.progData.episodeFilter.getDurationMin());
        this.slDur.maxValueProperty().set(this.progData.episodeFilter.getDurationMax());
        this.progData.episodeFilter.durationMinProperty().addListener(l -> this.slDur.minValueProperty().set(this.progData.episodeFilter.getDurationMin()));
        this.progData.episodeFilter.durationMaxProperty().addListener(l -> this.slDur.maxValueProperty().set(this.progData.episodeFilter.getDurationMax()));
        this.slDur.getSlider().lowValueChangingProperty().addListener((u, o, n) -> {
            if (!n.booleanValue()) {
                this.progData.episodeFilter.setDurationMin(this.slDur.getActMinValue());
            }
        });
        this.slDur.getSlider().highValueChangingProperty().addListener((u, o, n) -> {
            if (!n.booleanValue()) {
                this.progData.episodeFilter.setDurationMax(this.slDur.getActMaxValue());
            }
        });
    }

    private void initDaysFilter() {
        this.slTimeRange.setMin(0.0);
        this.slTimeRange.setMax(50.0);
        this.slTimeRange.setShowTickLabels(true);
        this.slTimeRange.setMajorTickUnit(10.0);
        this.slTimeRange.setBlockIncrement(5.0);
        this.slTimeRange.setLabelFormatter(new StringConverter<Double>(){

            @Override
            public String toString(Double x) {
                if (x == 0.0) {
                    return "alles";
                }
                return "" + x.intValue();
            }

            @Override
            public Double fromString(String string) {
                return null;
            }
        });
        this.slTimeRange.setValue(0.0);
        this.setLabelSlider();
        this.progData.episodeFilter.timeRangeProperty().addListener(l -> this.slTimeRange.setValue(this.progData.episodeFilter.timeRangeProperty().get()));
        this.slTimeRange.valueProperty().addListener((o, oldV, newV) -> this.setLabelSlider());
        this.slTimeRange.valueChangingProperty().addListener((u, o, n) -> {
            if (!n.booleanValue()) {
                this.progData.episodeFilter.setTimeRange((int)this.slTimeRange.getValue());
            }
        });
    }

    private void setLabelSlider() {
        String txtAll = "alles";
        int i = (int)this.slTimeRange.getValue();
        String tNr = "" + i;
        if (i == 0) {
            this.lblTimeRangeValue.setText("alles");
        } else {
            this.lblTimeRangeValue.setText(tNr + (i == 1 ? " Tag" : " Tage"));
        }
    }

    private void initTable() {
        this.scrollPane.setFitToHeight(true);
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setContent(this.tableView);
        TableColumn episodeColumn = new TableColumn("Podcast");
        episodeColumn.setCellValueFactory(new PropertyValueFactory("name"));
        episodeColumn.setCellFactory(this.cellFactory);
        episodeColumn.getStyleClass().add("alignCenterLeft");
        this.tableView.getColumns().addAll(episodeColumn);
        this.tableView.setEditable(false);
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_ALL_COLUMNS);
    }

    private void initFilter() {
        this.tableView.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2) {
                    this.tableView.getSelectionModel().clearSelection();
                }
            });
            return row;
        });
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> {
            if (this.tableView.getSelectionModel().isEmpty()) {
                this.progData.episodeFilter.setPodcastId(0L);
            } else if (newValue != null && oldValue != newValue) {
                this.progData.episodeFilter.setPodcastId(newValue.getId());
            }
        });
        this.progData.episodeFilter.podcastIdProperty().addListener((u, o, n) -> {
            Podcast podcast = this.progData.podcastList.getPodcastById(n.longValue());
            if (podcast != null) {
                this.tableView.getSelectionModel().select(podcast);
            } else {
                this.tableView.getSelectionModel().clearSelection();
            }
        });
        this.progData.episodeList.getPodcastList().addListener(c -> Platform.runLater(() -> {
            Podcast sel = (Podcast)this.tableView.getSelectionModel().getSelectedItem();
            this.tableView.getItems().setAll((Collection<Podcast>)this.progData.episodeList.getPodcastList());
            if (sel != null && this.tableView.getItems().contains(sel)) {
                this.tableView.getSelectionModel().select(sel);
            } else {
                this.progData.episodeFilter.setPodcastId(0L);
            }
        }));
        this.tableView.getItems().addAll((Collection<Podcast>)this.progData.episodeList.getPodcastList());
        this.cboGenre.valueProperty().bindBidirectional(this.progData.episodeFilter.genreProperty());
        this.progData.episodeList.getGenreList().addListener(change -> Platform.runLater(() -> {
            String sel = (String)this.cboGenre.getSelectionModel().getSelectedItem();
            this.cboGenre.getItems().setAll((Collection<String>)this.progData.episodeList.getGenreList());
            if (sel != null && !sel.isEmpty() && this.cboGenre.getItems().contains(sel)) {
                this.cboGenre.getSelectionModel().select(sel);
            } else {
                this.progData.episodeFilter.setGenre("");
            }
        }));
        this.cboGenre.getItems().addAll((Collection<String>)this.progData.episodeList.getGenreList());
        this.txtTitle.textProperty().bindBidirectional(this.progData.episodeFilter.titleProperty());
        FilterCheckRegEx fT = new FilterCheckRegEx(this.txtTitle);
        this.txtTitle.textProperty().addListener((observable2, oldValue, newValue) -> fT.checkPattern());
        this.txtDescription.textProperty().bindBidirectional(this.progData.episodeFilter.descriptionProperty());
        FilterCheckRegEx fD = new FilterCheckRegEx(this.txtDescription);
        this.txtDescription.textProperty().addListener((observable2, oldValue, newValue) -> fD.checkPattern());
    }
}

