/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.dialog;

import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2Hyperlink;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.data.SetFactory;
import de.p2tools.p2podder.gui.tools.HelpText;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class ImportSetDialogPanePath {
    private GridPane gridPane = new GridPane();
    private int row = 0;
    private final Stage stage;
    private final TextField txtPlayer = new TextField();

    public ImportSetDialogPanePath(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        this.txtPlayer.textProperty().unbindBidirectional(ProgConfig.SYSTEM_PATH_VLC);
    }

    public TitledPane makePath() {
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        this.gridPane.setPadding(new Insets(10.0));
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        Button btnEmpty = new Button(" ");
        btnEmpty.setVisible(false);
        this.gridPane.add(btnEmpty, 2, this.row);
        this.addPlayer();
        TitledPane tpConfig = new TitledPane("Programmpfade", this.gridPane);
        return tpConfig;
    }

    private void addPlayer() {
        Button btnFind = new Button("suchen");
        Text text = new Text("Pfad zum VLC-Player ausw\u00e4hlen");
        btnFind.setOnAction(event -> {
            ProgConfig.SYSTEM_PATH_VLC.setValue("");
            this.txtPlayer.setText(SetFactory.getTemplatePathVlc());
        });
        P2Hyperlink hyperlink = new P2Hyperlink(this.stage, "http://www.videolan.org", ProgConfig.SYSTEM_PROG_OPEN_URL);
        text.setStyle("-fx-font-weight: bold");
        this.txtPlayer.textProperty().bindBidirectional(ProgConfig.SYSTEM_PATH_VLC);
        Button btnFile = new Button();
        btnFile.setOnAction(event -> P2DirFileChooser.FileChooserOpenFile(this.stage, this.txtPlayer));
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        btnFile.setTooltip(new Tooltip("Programmdatei ausw\u00e4hlen"));
        Button btnHelp = P2Button.helpButton(this.stage, "Videoplayer", HelpText.PROG_PATHS);
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.getChildren().addAll((Node[])new Node[]{new Label("Website"), hyperlink});
        this.gridPane.add(text, 0, this.row);
        this.gridPane.add(this.txtPlayer, 0, ++this.row);
        this.gridPane.add(btnFile, 1, this.row);
        this.gridPane.add(btnFind, 2, this.row);
        this.gridPane.add(btnHelp, 3, this.row);
        this.gridPane.add(hBox, 0, ++this.row, 3, 1);
    }
}

