/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.dialog;

import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2Hyperlink;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.effect.BlendMode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class DownloadInfoDialog
extends P2DialogExtra {
    private Button btnOk = new Button("_Ok");
    private final GridPane gridPane = new GridPane();
    private DownloadData downloadData;

    public DownloadInfoDialog(ProgData progData, DownloadData downloadData) {
        super(progData.primaryStage, ProgConfig.EPISODE_DIALOG_EDIT_SIZE, "Download \u00e4ndern", true, false, P2DialogExtra.DECO.BORDER_SMALL);
        this.downloadData = downloadData;
        if (this.downloadData == null) {
            this.close();
            return;
        }
        this.init(true);
    }

    @Override
    public void make() {
        this.addOkButton(this.btnOk);
        this.initCont();
        this.initButton();
    }

    private void initCont() {
        this.getVBoxCont().getChildren().add(this.gridPane);
        this.gridPane.setHgap(10.0);
        this.gridPane.setVgap(15.0);
        this.gridPane.setPadding(new Insets(10.0));
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        VBox.setVgrow(this.gridPane, Priority.ALWAYS);
        int row = 0;
        this.gridAdd("Nr", "" + this.downloadData.getNo(), row);
        this.gridAdd("Titel", this.downloadData.getEpisodeTitle(), ++row);
        this.gridAdd("Genre", this.downloadData.getGenre(), ++row);
        this.gridAdd("Podcast", this.downloadData.getPodcastName(), ++row);
        ++row;
        TextArea taDescription = new TextArea();
        taDescription.setMinHeight(25.0);
        GridPane.setVgrow(taDescription, Priority.ALWAYS);
        taDescription.setEditable(false);
        taDescription.setWrapText(true);
        taDescription.setBlendMode(BlendMode.DARKEN);
        taDescription.setText(this.downloadData.getDescription());
        this.gridPane.add(new Label("Beschreibung:"), 0, row);
        this.gridPane.add(taDescription, 1, row, 3, 1);
        this.gridAdd("Gr\u00f6\u00dfe", this.downloadData.getDownloadSize().toString() + " MB", "Dauer", this.downloadData.getDurationStr(), ++row);
        this.gridAdd("Dateiname", this.downloadData.getDestFileName(), ++row);
        this.gridAdd("Pfad", this.downloadData.getDestPath(), ++row);
        this.gridPane.add(new Label("Url:"), 0, ++row);
        this.gridPane.add(new P2Hyperlink(this.downloadData.getEpisodeUrl()), 1, row, 3, 1);
        this.gridPane.add(new Label("Website:"), 0, ++row);
        this.gridPane.add(new P2Hyperlink(this.downloadData.getEpisodeWebsite()), 1, row, 3, 1);
        this.gridAdd("Datum", P2LDateFactory.toString(this.downloadData.getPubDate()), ++row);
    }

    private void gridAdd(String name, String value, int row) {
        this.gridPane.add(new Label(name + ":"), 0, row);
        this.gridPane.add(new Label(value), 1, row, 3, 1);
    }

    private void gridAdd(String name1, String value1, String name2, String value2, int row) {
        this.gridPane.add(new Label(name1 + ":"), 0, row);
        this.gridPane.add(new Label(value1), 1, row);
        this.gridPane.add(new Label(name2 + ":"), 2, row);
        this.gridPane.add(new Label(value2), 3, row);
    }

    private void initButton() {
        this.btnOk.setOnAction(event -> this.close());
    }
}

