/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.configdialog;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2Hyperlink;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.tools.update.SearchProgramUpdate;
import java.util.Collection;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.RowConstraints;
import javafx.stage.Stage;

public class PaneUpdate {
    private final ProgData progData;
    private final P2ToggleSwitch tglSearch = new P2ToggleSwitch("Einmal am Tag nach einer neuen Programmversion suchen");
    private final P2ToggleSwitch tglSearchBeta = new P2ToggleSwitch("Auch nach neuen Vorabversionen suchen");
    private final CheckBox chkDaily = new CheckBox("Zwischenschritte (Dailys) mit einbeziehen");
    private final Button btnNow = new Button("_Jetzt suchen");
    private Button btnHelpBeta;
    private final Stage stage;

    public PaneUpdate(Stage stage) {
        this.stage = stage;
        this.progData = ProgData.getInstance();
    }

    public void close() {
        this.tglSearch.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_SEARCH_UPDATE);
        this.tglSearchBeta.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_UPDATE_SEARCH_BETA);
        this.chkDaily.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_UPDATE_SEARCH_DAILY);
    }

    public void makeUpdate(Collection<TitledPane> result) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        TitledPane tpConfig = new TitledPane("Programmupdate", gridPane);
        result.add(tpConfig);
        this.tglSearch.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_SEARCH_UPDATE);
        Button btnHelp = P2Button.helpButton(this.stage, "Programmupdate suchen", "Beim Programmstart wird gepr\u00fcft, ob es eine neue Version des Programms gibt. Ist eine aktualisierte Version vorhanden, dann wird das gemeldet." + P2LibConst.LINE_SEPARATOR + "Das Programm wird aber nicht ungefragt ersetzt.");
        this.tglSearchBeta.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_UPDATE_SEARCH_BETA);
        this.chkDaily.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_UPDATE_SEARCH_DAILY);
        this.btnHelpBeta = P2Button.helpButton(this.stage, "Vorabversionen suchen", "Beim Programmstart wird gepr\u00fcft, ob es eine neue Vorabversion des Programms gibt. " + P2LibConst.LINE_SEPARATORx2 + "Das sind \"Zwischenschritte\" auf dem Weg zur n\u00e4chsten Version. Hier ist die Entwicklung noch nicht abgeschlossen und das Programm kann noch Fehler enthalten. Wer Lust hat einen Blick auf die n\u00e4chste Version zu werfen, ist eingeladen, die Vorabversionen zu testen." + P2LibConst.LINE_SEPARATORx2 + "Ist eine aktualisierte Vorabversion vorhanden, dann wird das gemeldet." + P2LibConst.LINE_SEPARATOR + "Das Programm wird aber nicht ungefragt ersetzt.");
        this.btnNow.setOnAction(event -> new SearchProgramUpdate(this.progData).searchNewProgramVersion(this.stage, true, false));
        this.checkBeta();
        this.tglSearch.selectedProperty().addListener((ob, ol, ne) -> this.checkBeta());
        this.tglSearchBeta.selectedProperty().addListener((ob, ol, ne) -> this.checkBeta());
        P2Hyperlink hyperlink = new P2Hyperlink("https://www.p2tools.de/", ProgConfig.SYSTEM_PROG_OPEN_URL);
        HBox hBoxHyper = new HBox();
        hBoxHyper.setAlignment(Pos.CENTER_LEFT);
        hBoxHyper.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        hBoxHyper.setSpacing(10.0);
        hBoxHyper.getChildren().addAll((Node[])new Node[]{new Label("Infos auch auf der Website:"), hyperlink});
        int row = 0;
        gridPane.add(this.tglSearch, 0, row);
        gridPane.add(btnHelp, 1, row);
        gridPane.add(this.tglSearchBeta, 0, ++row);
        gridPane.add(this.btnHelpBeta, 1, row);
        gridPane.add(this.chkDaily, 0, ++row, 2, 1);
        GridPane.setHalignment(this.chkDaily, HPos.RIGHT);
        gridPane.add(new Label(), 0, ++row);
        gridPane.add(this.btnNow, 0, ++row, 2, 1);
        GridPane.setHalignment(this.btnNow, HPos.RIGHT);
        gridPane.add(new Label(" "), 0, ++row);
        gridPane.add(hBoxHyper, 0, ++row);
        GridPane.setValignment(hBoxHyper, VPos.BOTTOM);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        gridPane.getRowConstraints().addAll((RowConstraints[])new RowConstraints[]{P2ColumnConstraints.getRcPrefSize(), P2ColumnConstraints.getRcPrefSize(), P2ColumnConstraints.getRcPrefSize(), P2ColumnConstraints.getRcPrefSize(), P2ColumnConstraints.getRcPrefSize(), P2ColumnConstraints.getRcVgrow()});
    }

    private void checkBeta() {
        this.tglSearchBeta.setDisable(!this.tglSearch.isSelected());
        this.btnHelpBeta.setDisable(!this.tglSearch.isSelected());
        this.chkDaily.setDisable(!this.tglSearchBeta.isSelected() || this.tglSearchBeta.isDisabled());
    }
}

