/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.configdialog;

import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import java.util.Collection;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class PaneTray {
    private final Stage stage;
    private final P2ToggleSwitch tglTray = new P2ToggleSwitch("Programm im System Tray anzeigen");
    private final P2ToggleSwitch tglOwnIcon = new P2ToggleSwitch("Ein eigenes Icon anzeigen");
    private final TextField txtPath = new TextField();

    public PaneTray(Stage stage) {
        this.stage = stage;
    }

    public void makeTray(Collection<TitledPane> result) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        TitledPane tpConfig = new TitledPane("System Tray", gridPane);
        result.add(tpConfig);
        this.tglTray.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_TRAY);
        Button btnHelpTray = P2Button.helpButton(this.stage, "Programm im System Tray anzeigen", "Im System Tray wird f\u00fcr das Programm ein Symbol angezeigt. Damit kann das Programm auf dem Desktop ausgeblendet werden.\n");
        GridPane.setHalignment(btnHelpTray, HPos.RIGHT);
        this.tglOwnIcon.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_TRAY_USE_OWN_ICON);
        this.tglOwnIcon.disableProperty().bind(this.tglTray.selectedProperty().not());
        Button btnHelpTrayOwnIcon = P2Button.helpButton(this.stage, "Eigenes Bild im Tray anzeigen", "Im System Tray wird f\u00fcr das Programm ein Symbol angezeigt. Damit kann ein eigens Bild daf\u00fcr verwendet werden.\n");
        GridPane.setHalignment(btnHelpTrayOwnIcon, HPos.RIGHT);
        btnHelpTrayOwnIcon.disableProperty().bind(this.tglTray.selectedProperty().not());
        Button btnFile = new Button();
        btnFile.setTooltip(new Tooltip("Einen Ordner f\u00fcr das Logfile ausw\u00e4hlen"));
        btnFile.setOnAction(event -> {
            String s = P2DirFileChooser.FileChooserSelect(ProgData.getInstance().primaryStage, "", "");
            if (!s.isEmpty()) {
                this.txtPath.setText(s);
            }
        });
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        btnFile.disableProperty().bind(this.tglOwnIcon.selectedProperty().not().or(this.tglTray.selectedProperty().not()));
        this.txtPath.textProperty().bindBidirectional(ProgConfig.SYSTEM_TRAY_ICON_PATH);
        this.txtPath.disableProperty().bind(this.tglOwnIcon.selectedProperty().not().or(this.tglTray.selectedProperty().not()));
        Label lblFile = new Label("Datei (png, jpg):");
        lblFile.disableProperty().bind(this.tglOwnIcon.selectedProperty().not().or(this.tglTray.selectedProperty().not()));
        int row = 0;
        gridPane.add(this.tglTray, 0, row, 2, 1);
        gridPane.add(btnHelpTray, 2, row);
        gridPane.add(this.tglOwnIcon, 0, ++row, 2, 1);
        gridPane.add(btnHelpTrayOwnIcon, 2, row);
        gridPane.add(lblFile, 0, ++row);
        gridPane.add(this.txtPath, 1, row);
        gridPane.add(btnFile, 2, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
    }

    public void close() {
    }
}

