/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.configdialog;

import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.shortcut.P2ShortcutKey;
import de.p2tools.p2podder.controller.config.PShortCut;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;
import javafx.util.Callback;

public class PaneShortcut {
    private final Stage stage;
    private final ProgData progData;
    private boolean released = true;
    private String newShortcutValue = "";
    private final TextArea txtLongDescription = new TextArea();
    private final TableView<P2ShortcutKey> tableView = new TableView();
    DoubleProperty doubleProperty;
    private Callback<TableColumn<P2ShortcutKey, String>, TableCell<P2ShortcutKey, String>> cellFactoryChange = param -> {
        TableCell<P2ShortcutKey, String> cell = new TableCell<P2ShortcutKey, String>(){

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                P2ShortcutKey pShortcut = (P2ShortcutKey)this.getTableView().getItems().get(this.getIndex());
                PaneShortcut.this.newShortcutValue = pShortcut.getActShortcut();
                Button btnChange = new Button("\u00c4ndern");
                btnChange.setTooltip(new Tooltip("Button klicken und dann das neue Tastenk\u00fcrzel eingeben"));
                btnChange.addEventFilter(KeyEvent.KEY_RELEASED, (? super T ke) -> {
                    PaneShortcut.this.released = true;
                    P2Log.sysLog("Shortcut: " + pShortcut.getDescription() + " \u00e4ndern von: " + pShortcut.getActShortcut() + " nach: " + PaneShortcut.this.newShortcutValue);
                    pShortcut.setActShortcut(PaneShortcut.this.newShortcutValue);
                });
                btnChange.addEventFilter(KeyEvent.KEY_PRESSED, (? super T ke) -> {
                    if (PaneShortcut.this.released) {
                        PaneShortcut.this.released = false;
                        PaneShortcut.this.newShortcutValue = "";
                    }
                    PaneShortcut.this.newShortcutValue = PaneShortcut.this.newShortcutValue.isEmpty() && !ke.getCode().equals((Object)KeyCode.ALT) && !ke.getCode().equals((Object)KeyCode.ALT_GRAPH) && !ke.getCode().equals((Object)KeyCode.CONTROL) && !ke.getCode().equals((Object)KeyCode.META) && !ke.getCode().equals((Object)KeyCode.SHIFT) && !ke.getCode().equals((Object)KeyCode.WINDOWS) ? "" : (PaneShortcut.this.newShortcutValue.isEmpty() ? ke.getCode().getName() : PaneShortcut.this.newShortcutValue + "+" + ke.getCode().getName());
                    ke.consume();
                });
                HBox hbox = new HBox();
                hbox.setSpacing(5.0);
                hbox.setAlignment(Pos.CENTER);
                hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
                hbox.getChildren().addAll((Node[])new Node[]{btnChange});
                this.setGraphic(hbox);
            }
        };
        return cell;
    };
    private Callback<TableColumn<P2ShortcutKey, String>, TableCell<P2ShortcutKey, String>> cellFactoryReset = param -> {
        TableCell<P2ShortcutKey, String> cell = new TableCell<P2ShortcutKey, String>(){

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                P2ShortcutKey pShortcut = (P2ShortcutKey)this.getTableView().getItems().get(this.getIndex());
                Button btnResete = new Button("Zur\u00fccksetzen");
                btnResete.setTooltip(new Tooltip("Ein Klick setzt wieder das Original Tastenk\u00fcrzel"));
                btnResete.setOnAction(a -> pShortcut.resetShortcut());
                HBox hbox = new HBox();
                hbox.setSpacing(5.0);
                hbox.setAlignment(Pos.CENTER);
                hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
                hbox.getChildren().add(btnResete);
                this.setGraphic(hbox);
            }
        };
        return cell;
    };

    public PaneShortcut(Stage stage) {
        this.stage = stage;
        this.progData = ProgData.getInstance();
        this.doubleProperty = ProgConfig.CONFIG_DIALOG_SHORTCUT_DIVIDER;
    }

    public void makeShortcut(Collection<TitledPane> result) {
        Button btnHelp = P2Button.helpButton(this.stage, "Tastenk\u00fcrzel \u00e4ndern", "Zum \u00c4ndern eines Tastenk\u00fcrzels, seinen \"\u00c4ndern\"-Button klicken und dann die gew\u00fcnschten neuen Tasten dr\u00fccken.\n\nDer \"Zur\u00fccksetzen\"-Button stellt den Originalzustand wieder her.\n\nDamit die \u00c4nderungen wirksam werden, muss das Programm neu gestartet werden.\n");
        SplitPane splitPane = new SplitPane();
        splitPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        splitPane.setOrientation(Orientation.VERTICAL);
        SplitPane.setResizableWithParent(this.tableView, Boolean.TRUE);
        SplitPane.setResizableWithParent(this.txtLongDescription, Boolean.FALSE);
        splitPane.getItems().addAll((Node[])new Node[]{this.tableView, this.txtLongDescription});
        ((SplitPane.Divider)splitPane.getDividers().get(0)).positionProperty().bindBidirectional(this.doubleProperty);
        this.initTable(this.tableView);
        this.txtLongDescription.setMinHeight(50.0);
        this.txtLongDescription.setPrefHeight(50.0);
        this.txtLongDescription.setEditable(false);
        this.txtLongDescription.setWrapText(true);
        HBox hBox = new HBox(5.0);
        hBox.setMaxHeight(Double.MAX_VALUE);
        hBox.getChildren().addAll((Node[])new Node[]{splitPane, btnHelp});
        HBox.setHgrow(splitPane, Priority.ALWAYS);
        TitledPane tpShortcut = new TitledPane("Tastenk\u00fcrzel", hBox);
        result.add(tpShortcut);
    }

    public void close() {
    }

    private void initTable(TableView<P2ShortcutKey> tableView) {
        TableColumn descriptionColumn = new TableColumn("Beschreibung");
        descriptionColumn.setCellValueFactory(new PropertyValueFactory("description"));
        descriptionColumn.getStyleClass().add("alignCenterLeft");
        TableColumn actShortcutColumn = new TableColumn("Tastenk\u00fcrzel");
        actShortcutColumn.setCellValueFactory(new PropertyValueFactory("actShortcut"));
        actShortcutColumn.getStyleClass().add("alignCenter");
        TableColumn changeColumn = new TableColumn("");
        changeColumn.getStyleClass().add("alignCenter");
        changeColumn.setCellFactory(this.cellFactoryChange);
        TableColumn resetColumn = new TableColumn("");
        resetColumn.getStyleClass().add("alignCenter");
        resetColumn.setCellFactory(this.cellFactoryReset);
        TableColumn orgShortcutColumn = new TableColumn("Original");
        orgShortcutColumn.setCellValueFactory(new PropertyValueFactory("orgShortcut"));
        orgShortcutColumn.getStyleClass().add("alignCenter");
        tableView.setMinHeight(200.0);
        tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        descriptionColumn.prefWidthProperty().bind(tableView.widthProperty().multiply(0.3));
        actShortcutColumn.prefWidthProperty().bind(tableView.widthProperty().multiply(0.2));
        changeColumn.prefWidthProperty().bind(tableView.widthProperty().multiply(0.1));
        resetColumn.prefWidthProperty().bind(tableView.widthProperty().multiply(0.15));
        orgShortcutColumn.prefWidthProperty().bind(tableView.widthProperty().multiply(0.15));
        tableView.getColumns().addAll(descriptionColumn, actShortcutColumn, changeColumn, resetColumn, orgShortcutColumn);
        tableView.setItems(PShortCut.getShortcutList());
        tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> Platform.runLater(this::setActReplaceData));
    }

    private void setActReplaceData() {
        P2ShortcutKey pShortcutAct = (P2ShortcutKey)this.tableView.getSelectionModel().getSelectedItem();
        this.txtLongDescription.setDisable(pShortcutAct == null);
        if (pShortcutAct != null) {
            this.txtLongDescription.setText(pShortcutAct.getLongDescription());
        } else {
            this.txtLongDescription.setText("");
        }
    }
}

