/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.configdialog;

import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.gui.tools.HelpText;
import java.util.Collection;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class PaneKeySize {
    private final P2ToggleSwitch tglStyle = new P2ToggleSwitch("Die Schriftgr\u00f6\u00dfe im Programm \u00e4ndern:");
    private Spinner<Integer> spinnerAnz = new Spinner();
    boolean changed = false;
    private final Stage stage;
    private final ProgData progData;

    public PaneKeySize(Stage stage, ProgData progData) {
        this.stage = stage;
        this.progData = progData;
    }

    public void close() {
        this.tglStyle.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_FONT_SIZE_CHANGE);
        int size = this.spinnerAnz.getValue();
        if (this.changed) {
            if (ProgConfig.SYSTEM_FONT_SIZE_CHANGE.get()) {
                ProgConfig.SYSTEM_STYLE_SIZE.setValue(size);
                P2Log.sysLog("Schriftgr\u00f6\u00dfe \u00e4ndern: " + size);
            } else {
                ProgConfig.SYSTEM_STYLE_SIZE.setValue(0);
                P2Log.sysLog("Schriftgr\u00f6\u00dfe nicht mehr \u00e4ndern.");
            }
        }
    }

    public void makeStyle(Collection<TitledPane> result) {
        this.tglStyle.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_FONT_SIZE_CHANGE);
        Button btnHelpStyle = P2Button.helpButton(this.stage, "Schriftgr\u00f6\u00dfe anpassen", HelpText.CONFIG_STYLE);
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        int row = 0;
        gridPane.add(this.tglStyle, 0, row, 2, 1);
        gridPane.add(btnHelpStyle, 2, row);
        gridPane.add(new Label(" "), 0, ++row);
        Label lbl = new Label("Schriftgr\u00f6\u00dfe:");
        gridPane.add(lbl, 0, ++row);
        gridPane.add(this.spinnerAnz, 1, row);
        lbl.disableProperty().bind(this.tglStyle.selectedProperty().not());
        this.spinnerAnz.disableProperty().bind(this.tglStyle.selectedProperty().not());
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        TitledPane tpConfig = new TitledPane("Schriftgr\u00f6\u00dfe", gridPane);
        if (result != null) {
            result.add(tpConfig);
        }
        this.init();
    }

    private void init() {
        this.spinnerAnz.setValueFactory(new SpinnerValueFactory.IntegerSpinnerValueFactory(6, 30, 1));
        this.spinnerAnz.getValueFactory().setValue(ProgConfig.SYSTEM_STYLE_SIZE.get() == 0 ? 14 : ProgConfig.SYSTEM_STYLE_SIZE.get());
        this.spinnerAnz.valueProperty().addListener((observable2, oldValue, newValue) -> {
            this.changed = true;
        });
        this.tglStyle.selectedProperty().addListener((observable2, oldValue, newValue) -> {
            this.changed = true;
        });
    }
}

