/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.configdialog;

import de.p2tools.p2lib.colordata.P2ColorData;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.tools.P2ColorFactory;
import de.p2tools.p2podder.controller.config.PEvents;
import de.p2tools.p2podder.controller.config.ProgColorList;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import java.util.Collection;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.util.Callback;

public class PaneColor {
    private final Stage stage;
    private final P2ToggleSwitch tglDarkTheme = new P2ToggleSwitch("Dunkles Erscheinungsbild der Programmoberfl\u00e4che");
    private final P2ToggleSwitch tglBlackWhiteIcon = new P2ToggleSwitch("Schwarz-Wei\u00dfe Icons");
    private final Callback<TableColumn<P2ColorData, String>, TableCell<P2ColorData, String>> cellFactoryUse = param -> new TableCell<P2ColorData, String>(){

        @Override
        public void updateItem(String item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setGraphic(null);
                this.setText(null);
                return;
            }
            P2ColorData pColorData = (P2ColorData)this.getTableView().getItems().get(this.getIndex());
            HBox hbox = new HBox();
            hbox.setSpacing(5.0);
            hbox.setAlignment(Pos.CENTER);
            hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
            CheckBox checkBox = new CheckBox("");
            checkBox.setSelected(pColorData.isUse());
            checkBox.setOnAction(a -> {
                pColorData.setUse(checkBox.isSelected());
                ProgData.getInstance().pEventHandler.notifyListener(new P2Event(PEvents.EVENT_REFRESH_TABLE));
            });
            hbox.getChildren().add(checkBox);
            this.setGraphic(hbox);
        }
    };
    private final Callback<TableColumn<P2ColorData, String>, TableCell<P2ColorData, String>> cellFactoryChange = param -> new TableCell<P2ColorData, String>(){

        @Override
        public void updateItem(String item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setGraphic(null);
                this.setText(null);
                return;
            }
            P2ColorData p2ColorData = (P2ColorData)this.getTableView().getItems().get(this.getIndex());
            HBox hbox = new HBox();
            hbox.setSpacing(5.0);
            hbox.setAlignment(Pos.CENTER);
            hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
            ColorPicker colorPicker = new ColorPicker();
            colorPicker.getStyleClass().add("split-button");
            colorPicker.setValue(p2ColorData.getColor());
            colorPicker.setOnAction(a -> {
                Color fxColor = (Color)colorPicker.getValue();
                p2ColorData.setColor(fxColor);
                ProgData.getInstance().pEventHandler.notifyListener(new P2Event(PEvents.EVENT_REFRESH_TABLE));
            });
            hbox.getChildren().addAll((Node[])new Node[]{colorPicker});
            this.setGraphic(hbox);
        }
    };
    private final Callback<TableColumn<P2ColorData, Color>, TableCell<P2ColorData, Color>> cellFactoryColor = param -> new TableCell<P2ColorData, Color>(){

        @Override
        public void updateItem(Color item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setGraphic(null);
                this.setText(null);
                return;
            }
            P2ColorData p2ColorData = (P2ColorData)this.getTableView().getItems().get(this.getIndex());
            this.setStyle("-fx-background-color:" + p2ColorData.getColorSelectedToWeb());
        }
    };
    private final Callback<TableColumn<P2ColorData, Color>, TableCell<P2ColorData, Color>> cellFactoryResetColor = param -> new TableCell<P2ColorData, Color>(){

        @Override
        public void updateItem(Color item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setGraphic(null);
                this.setText(null);
                return;
            }
            P2ColorData p2ColorData = (P2ColorData)this.getTableView().getItems().get(this.getIndex());
            this.setStyle("-fx-background-color:" + P2ColorFactory.getColorToWeb(p2ColorData.getResetColor()));
        }
    };
    private final Callback<TableColumn<P2ColorData, String>, TableCell<P2ColorData, String>> cellFactoryReset = param -> new TableCell<P2ColorData, String>(){

        @Override
        public void updateItem(String item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setGraphic(null);
                this.setText(null);
                return;
            }
            P2ColorData p2ColorData = (P2ColorData)this.getTableView().getItems().get(this.getIndex());
            HBox hbox = new HBox();
            hbox.setSpacing(5.0);
            hbox.setAlignment(Pos.CENTER);
            hbox.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
            Button button = new Button("Reset");
            button.setOnAction(a -> {
                p2ColorData.resetColor();
                ProgData.getInstance().pEventHandler.notifyListener(new P2Event(PEvents.EVENT_REFRESH_TABLE));
            });
            hbox.getChildren().add(button);
            this.setGraphic(hbox);
        }
    };

    public PaneColor(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        this.tglDarkTheme.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_DARK_THEME);
        this.tglBlackWhiteIcon.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_BLACK_WHITE_ICON);
    }

    public void make(Collection<TitledPane> result) {
        VBox vBox = new VBox();
        vBox.setFillWidth(true);
        vBox.setSpacing(10.0);
        vBox.setPadding(new Insets(10.0));
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        this.tglDarkTheme.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_DARK_THEME);
        Button btnHelpTheme = P2Button.helpButton(this.stage, "Erscheinungsbild der Programmoberfl\u00e4che", "Das Programm wird damit mit einer dunklen Programmoberfl\u00e4che angezeigt. Damit alle Elemente der Programmoberfl\u00e4che ge\u00e4ndert werden, kann ein Programmneustart notwendig sein.\n");
        this.tglBlackWhiteIcon.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_BLACK_WHITE_ICON);
        Button btnHelpIcon = P2Button.helpButton(this.stage, "Erscheinungsbild der Programmoberfl\u00e4che", "Die Programmicons werden in Schwarz-Wei\u00df angezeigt. F\u00fcr einige Elemente kann ein Programmneustart notwendig sein.\n");
        gridPane.add(this.tglDarkTheme, 0, 0);
        gridPane.add(btnHelpTheme, 1, 0);
        gridPane.add(this.tglBlackWhiteIcon, 0, 1);
        gridPane.add(btnHelpIcon, 1, 1);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        TableView<P2ColorData> tableView = new TableView<P2ColorData>();
        VBox.setVgrow(tableView, Priority.ALWAYS);
        this.initTableColor(tableView);
        ProgConfig.SYSTEM_DARK_THEME.addListener((u, o, n) -> {
            ProgColorList.setColorTheme();
            tableView.refresh();
        });
        Button button = new Button("Alle _Farben zur\u00fccksetzen");
        button.setOnAction(event -> {
            ProgColorList.resetAllColor();
            ProgData.getInstance().pEventHandler.notifyListener(new P2Event(PEvents.EVENT_REFRESH_TABLE));
        });
        HBox hBox = new HBox();
        hBox.getChildren().add(button);
        hBox.setPadding(new Insets(0.0));
        hBox.setAlignment(Pos.CENTER_RIGHT);
        vBox.getChildren().addAll((Node[])new Node[]{gridPane, tableView, hBox});
        TitledPane tpColor = new TitledPane("Farben", vBox);
        result.add(tpColor);
    }

    private void initTableColor(TableView<P2ColorData> tableView) {
        TableColumn useColumn = new TableColumn("Verwenden");
        useColumn.setCellFactory(this.cellFactoryUse);
        useColumn.getStyleClass().add("alignCenter");
        TableColumn textColumn = new TableColumn("Beschreibung");
        textColumn.setCellValueFactory(new PropertyValueFactory("text"));
        textColumn.getStyleClass().add("alignCenterLeft");
        TableColumn changeColumn = new TableColumn("Farbe");
        changeColumn.setCellFactory(this.cellFactoryChange);
        changeColumn.getStyleClass().add("alignCenter");
        TableColumn colorColumn = new TableColumn("Farbe");
        colorColumn.setCellValueFactory(new PropertyValueFactory("color"));
        colorColumn.setCellFactory(this.cellFactoryColor);
        colorColumn.getStyleClass().add("alignCenter");
        TableColumn colorOrgColumn = new TableColumn("Original");
        colorOrgColumn.setCellValueFactory(new PropertyValueFactory("resetColor"));
        colorOrgColumn.setCellFactory(this.cellFactoryResetColor);
        colorOrgColumn.getStyleClass().add("alignCenter");
        TableColumn resetColumn = new TableColumn("Reset");
        resetColumn.setCellFactory(this.cellFactoryReset);
        resetColumn.getStyleClass().add("alignCenter");
        tableView.setMinHeight(200.0);
        tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        tableView.getColumns().addAll(useColumn, textColumn, changeColumn, colorColumn, colorOrgColumn, resetColumn);
        tableView.setItems(ProgColorList.getInstance());
    }
}

