/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.configdialog;

import de.p2tools.p2lib.dialogs.accordion.P2AccordionPane;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.gui.configdialog.PaneColor;
import de.p2tools.p2podder.gui.configdialog.PaneConfig;
import de.p2tools.p2podder.gui.configdialog.PaneKeySize;
import de.p2tools.p2podder.gui.configdialog.PaneLogFile;
import de.p2tools.p2podder.gui.configdialog.PaneProg;
import de.p2tools.p2podder.gui.configdialog.PaneShortcut;
import de.p2tools.p2podder.gui.configdialog.PaneTray;
import de.p2tools.p2podder.gui.configdialog.PaneUpdate;
import java.util.ArrayList;
import java.util.Collection;
import javafx.scene.control.TitledPane;
import javafx.stage.Stage;

public class ControllerConfig
extends P2AccordionPane {
    private PaneColor paneColor;
    private PaneShortcut paneShortcut;
    private PaneKeySize paneKeySize;
    private PaneTray paneTray;
    private PaneConfig paneConfig;
    private PaneLogFile paneLogFile;
    private PaneProg paneProg;
    private PaneUpdate paneUpdate;
    private final Stage stage;
    private final ProgData progData;

    public ControllerConfig(Stage stage) {
        super(ProgConfig.CONFIG_DIALOG_ACCORDION, ProgConfig.SYSTEM_CONFIG_DIALOG_CONFIG);
        this.stage = stage;
        this.progData = ProgData.getInstance();
        this.init();
    }

    @Override
    public void close() {
        super.close();
        this.paneConfig.close();
        this.paneTray.close();
        this.paneColor.close();
        this.paneShortcut.close();
        this.paneKeySize.close();
        this.paneLogFile.close();
        this.paneProg.close();
        this.paneUpdate.close();
    }

    @Override
    public Collection<TitledPane> createPanes() {
        ArrayList<TitledPane> result = new ArrayList<TitledPane>();
        this.paneConfig = new PaneConfig(this.stage);
        this.paneConfig.makeConfig(result);
        this.paneTray = new PaneTray(this.stage);
        this.paneTray.makeTray(result);
        this.paneLogFile = new PaneLogFile(this.stage);
        this.paneLogFile.makeLogfile(result);
        this.paneColor = new PaneColor(this.stage);
        this.paneColor.make(result);
        this.paneShortcut = new PaneShortcut(this.stage);
        this.paneShortcut.makeShortcut(result);
        this.paneKeySize = new PaneKeySize(this.stage, this.progData);
        this.paneKeySize.makeStyle(result);
        this.paneProg = new PaneProg(this.stage);
        this.paneProg.makeProg(result);
        this.paneUpdate = new PaneUpdate(this.stage);
        this.paneUpdate.makeUpdate(result);
        return result;
    }
}

