/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui;

import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.date.P2LDateTimeFactory;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.config.PEvents;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.worker.InfoFactory;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

public class StatusBarController
extends AnchorPane {
    private final StackPane stackPane = new StackPane();
    private final Label lblLeftEpisode = new Label();
    private final Label lblRightEpisode = new Label();
    private final Label lblLeftPodcast = new Label();
    private final Label lblRightPodcast = new Label();
    private final Label lblLeftDownload = new Label();
    private final Label lblRightDownload = new Label();
    private final Pane nonePane;
    private final Pane episodePane;
    private final Pane podcastPane;
    private final Pane downloadPane;
    private StatusbarIndex statusbarIndex = StatusbarIndex.NONE;
    private boolean loadList = false;
    private final ProgData progData;
    private boolean stopTimer = false;

    public StatusBarController(ProgData progData) {
        this.progData = progData;
        this.getChildren().addAll((Node[])new Node[]{this.stackPane});
        AnchorPane.setLeftAnchor(this.stackPane, 0.0);
        AnchorPane.setBottomAnchor(this.stackPane, 0.0);
        AnchorPane.setRightAnchor(this.stackPane, 0.0);
        AnchorPane.setTopAnchor(this.stackPane, 0.0);
        this.nonePane = new HBox();
        this.episodePane = this.getHbox(this.lblLeftEpisode, this.lblRightEpisode);
        this.podcastPane = this.getHbox(this.lblLeftPodcast, this.lblRightPodcast);
        this.downloadPane = this.getHbox(this.lblLeftDownload, this.lblRightDownload);
        this.make();
    }

    private HBox getHbox(Label lblLeft, Label lblRight) {
        HBox hBox = new HBox();
        hBox.setPadding(new Insets(2.0, 5.0, 2.0, 5.0));
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER_RIGHT);
        lblLeft.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow(lblLeft, Priority.ALWAYS);
        hBox.getChildren().addAll((Node[])new Node[]{lblLeft, lblRight});
        hBox.setStyle("-fx-background-color: -fx-background ;");
        return hBox;
    }

    private void make() {
        this.stackPane.getChildren().addAll((Node[])new Node[]{this.nonePane, this.episodePane, this.podcastPane, this.downloadPane});
        this.stackPane.setPadding(new Insets(2.0, 5.0, 2.0, 5.0));
        this.nonePane.toFront();
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_TIMER_SECOND){

            public void pingGui(P2Event runEvent) {
                try {
                    if (!StatusBarController.this.stopTimer) {
                        StatusBarController.this.setStatusbarIndex(StatusBarController.this.statusbarIndex);
                    }
                }
                catch (Exception ex) {
                    P2Log.errorLog(936251087, ex);
                }
            }
        });
    }

    public void setStatusbarIndex(StatusbarIndex statusbarIndex) {
        this.statusbarIndex = statusbarIndex;
        switch (statusbarIndex) {
            case EPISODE: {
                this.episodePane.toFront();
                this.setInfoEpisode();
                this.setRightText();
                break;
            }
            case PODCAST: {
                this.podcastPane.toFront();
                this.setInfoPodcast();
                this.setRightText();
                break;
            }
            case DOWNLOAD: {
                this.downloadPane.toFront();
                this.setInfoDownload();
                this.setRightText();
                break;
            }
            default: {
                this.nonePane.toFront();
            }
        }
    }

    private void setInfoEpisode() {
        this.lblLeftEpisode.setText(InfoFactory.getInfosEpisode());
    }

    private void setInfoPodcast() {
        this.lblLeftPodcast.setText(InfoFactory.getInfosPodcasts());
    }

    private void setInfoDownload() {
        this.lblLeftDownload.setText(InfoFactory.getInfosDownloads());
    }

    private void setRightText() {
        Object strText = "";
        int day = this.getAge();
        if (day == 0) {
            strText = (String)strText + "Podcasts heute geladen";
        } else if (day > 0) {
            strText = "Podcasts geladen: ";
            strText = (String)strText + P2LDateTimeFactory.toStringDate((LocalDateTime)ProgConfig.META_PODCAST_LIST_DATE.getValue());
            strText = (String)strText + "  ";
            strText = (String)strText + "||  Alter: ";
            String strDay = String.valueOf(day);
            strText = (String)strText + strDay;
            strText = (String)strText + " Tage";
        }
        this.lblRightEpisode.setText((String)strText);
        this.lblRightPodcast.setText((String)strText);
        this.lblRightDownload.setText((String)strText);
    }

    private int getAge() {
        int days = -1;
        LocalDateTime stationDate = (LocalDateTime)ProgConfig.META_PODCAST_LIST_DATE.getValue();
        if (stationDate != null && !stationDate.isEqual(LocalDateTime.MIN) && (days = (int)ChronoUnit.DAYS.between((Temporal)ProgConfig.META_PODCAST_LIST_DATE.getValue(), LocalDateTime.now())) < 0) {
            days = 0;
        }
        return days;
    }

    public static enum StatusbarIndex {
        NONE,
        EPISODE,
        DOWNLOAD,
        PODCAST;

    }
}

