/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui;

import de.p2tools.p2lib.tools.shortcut.P2ShortcutWorker;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.PShortCut;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.podcast.PodcastFactory;
import de.p2tools.p2podder.gui.ToolBarButton;
import javafx.beans.property.BooleanProperty;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;

public class PodcastMenu {
    private final VBox vBox;
    private final ProgData progData;
    BooleanProperty boolFilterOn = ProgConfig.PODCAST__FILTER_IS_SHOWING;
    BooleanProperty boolInfoOn = ProgConfig.PODCAST__INFO_IS_SHOWING;

    public PodcastMenu(VBox vBox) {
        this.vBox = vBox;
        this.progData = ProgData.getInstance();
    }

    public void init() {
        this.vBox.getChildren().clear();
        this.initPodcastMenu();
        this.initButton();
    }

    private void initButton() {
        VBox vBoxSpace = new VBox();
        vBoxSpace.setMaxHeight(0.0);
        vBoxSpace.setMinHeight(0.0);
        this.vBox.getChildren().add(vBoxSpace);
        ToolBarButton btUpdate = new ToolBarButton(this.vBox, "Alle Podcasts aktualisieren", "Alle Podcasts aktualisieren", ProgIcons.ICON_TOOLBAR_REFRESH.getImageView());
        ToolBarButton btnAdd = new ToolBarButton(this.vBox, "Einen neuen Podcast anlegen", "Einen neuen Podcast anlegen", ProgIcons.ICON_TOOLBAR_NEW.getImageView());
        ToolBarButton btnDel = new ToolBarButton(this.vBox, "Markierte Podcasts l\u00f6schen", "Markierte Podcasts l\u00f6schen", ProgIcons.ICON_TOOLBAR_DEL.getImageView());
        ToolBarButton btnChange = new ToolBarButton(this.vBox, "Markierte Podcasts \u00e4ndern", "Markierte Podcasts \u00e4ndern", ProgIcons.ICON_TOOLBAR_CONFIG.getImageView());
        ToolBarButton btInfo = new ToolBarButton(this.vBox, "Info-Dialog anzeigen", "Info-Dialog anzeigen", ProgIcons.ICON_TOOLBAR_INFO.getImageView());
        vBoxSpace = new VBox();
        vBoxSpace.setMaxHeight(10.0);
        vBoxSpace.setMinHeight(10.0);
        this.vBox.getChildren().add(vBoxSpace);
        btUpdate.setOnAction(a -> this.progData.worker.updatePodcast(true));
        btnAdd.setOnAction(a -> PodcastFactory.addNewPodcast());
        btnDel.setOnAction(a -> this.progData.podcastGui.getPodcastGuiController().delSelPodcast());
        btnChange.setOnAction(a -> this.progData.podcastGui.getPodcastGuiController().changePodcast());
        btInfo.setOnAction(a -> this.progData.episodeInfoDialogController.toggleShowInfo());
    }

    private void initPodcastMenu() {
        MenuButton mb = new MenuButton("");
        mb.setTooltip(new Tooltip("Podcastmen\u00fc anzeigen"));
        mb.setGraphic(ProgIcons.ICON_TOOLBAR_MENU.getImageView());
        mb.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-0"});
        MenuItem miUpdate = new MenuItem("Markierte Podcasts aktualisieren");
        miUpdate.setOnAction(a -> this.progData.worker.updatePodcast(false));
        P2ShortcutWorker.addShortCut(miUpdate, PShortCut.SHORTCUT_UPDATE_PODCAST);
        MenuItem miUpdateAll = new MenuItem("Alle Podcasts aktualisieren");
        miUpdateAll.setOnAction(a -> this.progData.worker.updatePodcast(true));
        MenuItem miDel = new MenuItem("Markierte Podcasts l\u00f6schen");
        miDel.setOnAction(a -> this.progData.podcastGui.getPodcastGuiController().delSelPodcast());
        MenuItem miDelAll = new MenuItem("Alle Podcasts l\u00f6schen");
        miDelAll.setOnAction(a -> this.progData.podcastList.removeAllPodcast());
        MenuItem miSetActive = new MenuItem("Markierte Podcasts einschalten");
        miSetActive.setOnAction(a -> this.progData.worker.setPodcastActive(true));
        MenuItem miSetOffActive = new MenuItem("Markierte Podcasts ausschalten");
        miSetOffActive.setOnAction(a -> this.progData.worker.setPodcastActive(false));
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miUpdate, miUpdateAll, miDel, miDelAll, miSetActive, miSetOffActive});
        CheckMenuItem miShowFilter = new CheckMenuItem("Filter anzeigen");
        miShowFilter.disableProperty().bind(ProgConfig.PODCAST__FILTER_IS_RIP);
        miShowFilter.selectedProperty().bindBidirectional(this.boolFilterOn);
        CheckMenuItem miShowInfo = new CheckMenuItem("Infos anzeigen");
        miShowInfo.disableProperty().bind(ProgConfig.PODCAST__PANE_INFO_IS_RIP);
        miShowInfo.selectedProperty().bindBidirectional(this.boolInfoOn);
        mb.getItems().add(new SeparatorMenuItem());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miShowFilter, miShowInfo});
        this.vBox.getChildren().add(mb);
    }
}

