/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui;

import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2RowMoveFactory;
import de.p2tools.p2lib.guitools.P2TableFactory;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneController;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneDto;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneFactory;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import de.p2tools.p2podder.gui.PanePodcastInfo;
import de.p2tools.p2podder.gui.PodcastGuiTableContextMenu;
import de.p2tools.p2podder.gui.podcastadd.PodcastAddDialogController;
import de.p2tools.p2podder.gui.tools.table.Table;
import de.p2tools.p2podder.gui.tools.table.TablePodcast;
import java.util.ArrayList;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableRow;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;

public class PodcastGuiController
extends AnchorPane {
    private final SplitPane splitPane = new SplitPane();
    private final ScrollPane scrollPane = new ScrollPane();
    private final PanePodcastInfo panePodcastInfo;
    private final P2ClosePaneController infoController;
    private final TablePodcast tableView;
    private final ProgData progData;
    private final BooleanProperty bound = new SimpleBooleanProperty(false);
    private final SortedList<Podcast> sortedList;
    private final KeyCombination STRG_A = new KeyCodeCombination(KeyCode.A, KeyCombination.CONTROL_ANY);
    private final KeyCombination SPACE = new KeyCodeCombination(KeyCode.SPACE, new KeyCombination.Modifier[0]);
    BooleanProperty boolInfoOn = ProgConfig.PODCAST__INFO_IS_SHOWING;

    public PodcastGuiController() {
        this.progData = ProgData.getInstance();
        this.tableView = new TablePodcast(Table.TABLE_ENUM.PODCAST, this.progData);
        this.sortedList = this.progData.podcastList.getSortedList();
        this.sortedList.addListener(c -> this.selectPodcast());
        AnchorPane.setLeftAnchor(this.splitPane, 0.0);
        AnchorPane.setBottomAnchor(this.splitPane, 0.0);
        AnchorPane.setRightAnchor(this.splitPane, 0.0);
        AnchorPane.setTopAnchor(this.splitPane, 0.0);
        this.splitPane.setOrientation(Orientation.VERTICAL);
        this.getChildren().addAll((Node[])new Node[]{this.splitPane});
        this.scrollPane.setFitToHeight(true);
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setContent(this.tableView);
        this.panePodcastInfo = new PanePodcastInfo();
        P2ClosePaneDto infoDto = new P2ClosePaneDto(this.panePodcastInfo, ProgConfig.PODCAST__PANE_INFO_IS_RIP, ProgConfig.PODCAST__DIALOG_INFO_SIZE, ProgData.PODCAST_TAB_ON, "Info", "Beschreibung", false);
        this.infoController = new P2ClosePaneController(infoDto, ProgConfig.PODCAST__INFO_IS_SHOWING);
        ProgConfig.PODCAST__INFO_IS_SHOWING.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        ProgConfig.PODCAST__PANE_INFO_IS_RIP.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        this.setInfoPane();
        this.initTable();
    }

    public void isShown() {
        this.tableView.requestFocus();
        this.setPodcast();
    }

    public void tableRefresh() {
        this.tableView.refresh();
    }

    public int getPodcastShown() {
        return this.tableView.getItems().size();
    }

    public int getSelCount() {
        return this.tableView.getSelectionModel().getSelectedItems().size();
    }

    public void changePodcast() {
        ArrayList<Podcast> list = this.getSelList();
        if (list.isEmpty()) {
            return;
        }
        new PodcastAddDialogController(this.progData, list, false);
    }

    private void setPodcast() {
        Podcast podcast = (Podcast)this.tableView.getSelectionModel().getSelectedItem();
        this.panePodcastInfo.setStation(podcast);
    }

    private void selectPodcast() {
        Platform.runLater(() -> {
            if (this.tableView.getItems().isEmpty()) {
                return;
            }
            Podcast selPodcast = (Podcast)this.tableView.getSelectionModel().getSelectedItem();
            if (selPodcast != null) {
                this.tableView.scrollTo(selPodcast);
            } else {
                this.tableView.scrollTo(0);
                this.tableView.getSelectionModel().select(0);
            }
        });
    }

    public void delPodcast() {
        Optional<Podcast> sel = this.getSel();
        sel.ifPresent(podcast -> this.progData.podcastList.removePodcast((Podcast)podcast));
    }

    public void delSelPodcast() {
        this.progData.podcastList.removePodcast(this.getSelList());
    }

    public void saveTable() {
        Table.saveTable(this.tableView, Table.TABLE_ENUM.PODCAST);
    }

    public void refreshTable() {
        P2TableFactory.refreshTable(this.tableView);
    }

    public ArrayList<Podcast> getSelList() {
        ArrayList<Podcast> ret = new ArrayList<Podcast>(this.tableView.getSelectionModel().getSelectedItems());
        if (ret.isEmpty()) {
            P2Alert.showInfoNoSelection();
        }
        return ret;
    }

    public Optional<Podcast> getSel() {
        return this.getSel(true);
    }

    public Optional<Podcast> getSel(boolean show) {
        int selectedTableRow = this.tableView.getSelectionModel().getSelectedIndex();
        if (selectedTableRow >= 0) {
            return Optional.of((Podcast)this.tableView.getSelectionModel().getSelectedItem());
        }
        if (show) {
            P2Alert.showInfoNoSelection();
        }
        return Optional.empty();
    }

    private void setInfoPane() {
        P2ClosePaneFactory.setSplit(this.bound, this.splitPane, this.infoController, false, this.scrollPane, ProgConfig.PODCAST__INFO_DIVIDER, ProgConfig.PODCAST__INFO_IS_SHOWING);
    }

    private void initTable() {
        Table.setTable(this.tableView);
        this.tableView.setItems(this.sortedList);
        this.sortedList.comparatorProperty().bind(this.tableView.comparatorProperty());
        this.tableView.setOnMouseClicked(m -> {
            if (m.getButton().equals((Object)MouseButton.PRIMARY) && m.getClickCount() == 2) {
                this.changePodcast();
            }
        });
        this.tableView.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                Optional<Podcast> optionalStation = this.getSel(false);
                Podcast podcast = optionalStation.orElse(null);
                ContextMenu contextMenu = new PodcastGuiTableContextMenu(this.progData, this, this.tableView).getContextMenu(podcast);
                this.tableView.setContextMenu(contextMenu);
            }
        });
        this.tableView.addEventFilter(KeyEvent.KEY_PRESSED, (? super T event) -> {
            if (this.SPACE.match((KeyEvent)event)) {
                P2TableFactory.scrollVisibleRangeDown(this.tableView);
                event.consume();
            }
            if (P2TableFactory.SPACE_SHIFT.match((KeyEvent)event)) {
                P2TableFactory.scrollVisibleRangeUp(this.tableView);
                event.consume();
            }
            if (this.STRG_A.match((KeyEvent)event) && this.tableView.getItems().size() > 3000) {
                P2Log.sysLog("STRG-A: lange Liste -> verhindern");
                event.consume();
            }
        });
        this.tableView.setRowFactory(new P2RowMoveFactory<Podcast>(table -> {
            TableRow row = new TableRow();
            row.hoverProperty().addListener(observable2 -> {
                Podcast podcast = (Podcast)row.getItem();
                if (row.isHover() && podcast != null) {
                    this.panePodcastInfo.setStation(podcast);
                } else {
                    this.setPodcast();
                }
            });
            return row;
        }, this.progData.podcastList));
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> Platform.runLater(this::setPodcast));
    }
}

