/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui;

import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2Hyperlink;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class PanePodcastInfo
extends VBox {
    private final Label lblTitle = new Label("");
    private final Label lblGenre = new Label("");
    private final Label lblSumEpisodes = new Label("");
    private final Label lblDate = new Label("");
    private final CheckBox chkActive = new CheckBox();
    private final P2Hyperlink hyperlinkWebsite = new P2Hyperlink("", ProgConfig.SYSTEM_PROG_OPEN_URL);
    private final P2Hyperlink hyperlinkUrl = new P2Hyperlink("", ProgConfig.SYSTEM_PROG_OPEN_URL);

    public PanePodcastInfo() {
        this.initInfo();
        VBox.setVgrow(this, Priority.ALWAYS);
    }

    public void initInfo() {
        GridPane gridPaneLeft = new GridPane();
        GridPane gridPaneRight = new GridPane();
        SplitPane splitPane = new SplitPane();
        splitPane.getItems().addAll((Node[])new Node[]{gridPaneLeft, gridPaneRight});
        ((SplitPane.Divider)splitPane.getDividers().get(0)).positionProperty().bindBidirectional(ProgConfig.PODCAST_GUI_INFO_DIVIDER);
        VBox.setVgrow(splitPane, Priority.ALWAYS);
        this.getChildren().add(splitPane);
        this.lblTitle.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        this.chkActive.setDisable(true);
        gridPaneLeft.setHgap(5.0);
        gridPaneLeft.setVgap(5.0);
        gridPaneLeft.setPadding(new Insets(10.0));
        gridPaneLeft.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        int row = 0;
        gridPaneLeft.add(new Label("Titel:"), 0, row);
        gridPaneLeft.add(this.lblTitle, 1, row);
        gridPaneLeft.add(new Label("Website:"), 0, ++row);
        gridPaneLeft.add(this.hyperlinkWebsite, 1, row);
        gridPaneLeft.add(new Label("Podcast-URL:"), 0, ++row);
        gridPaneLeft.add(this.hyperlinkUrl, 1, row);
        gridPaneRight.setHgap(5.0);
        gridPaneRight.setVgap(5.0);
        gridPaneRight.setPadding(new Insets(10.0));
        gridPaneRight.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        row = 0;
        gridPaneRight.add(new Label("Aktiv:"), 0, row);
        gridPaneRight.add(this.chkActive, 1, row);
        gridPaneRight.add(new Label("Genre:"), 0, ++row);
        gridPaneRight.add(this.lblGenre, 1, row);
        gridPaneRight.add(new Label("Episoden:"), 0, ++row);
        gridPaneRight.add(this.lblSumEpisodes, 1, row);
        gridPaneRight.add(new Label("Datum:"), 0, ++row);
        gridPaneRight.add(this.lblDate, 1, row);
    }

    public void setStation(Podcast podcast) {
        if (podcast == null) {
            this.lblTitle.setText("");
            this.lblGenre.setText("");
            this.lblSumEpisodes.setText("");
            this.lblDate.setText("");
            this.chkActive.selectedProperty().unbind();
            this.chkActive.setSelected(false);
            this.hyperlinkWebsite.setUrl("");
            this.hyperlinkUrl.setUrl("");
            return;
        }
        this.lblTitle.setText(podcast.getName());
        this.lblGenre.setText(podcast.getGenre());
        this.lblSumEpisodes.setText("" + podcast.getAmountEpisodes());
        this.lblDate.setText(P2LDateFactory.toString(podcast.getGenDate()));
        this.chkActive.selectedProperty().bind(podcast.activeProperty());
        this.hyperlinkWebsite.setUrl(podcast.getWebsite());
        this.hyperlinkUrl.setUrl(podcast.getUrl());
    }
}

