/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui;

import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2RowMoveFactory;
import de.p2tools.p2lib.guitools.P2TableFactory;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneController;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneDto;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneFactory;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2podder.controller.config.PEvents;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.gui.EpisodeGuiTableContextMenu;
import de.p2tools.p2podder.gui.PaneEpisodeInfo;
import de.p2tools.p2podder.gui.tools.table.Table;
import de.p2tools.p2podder.gui.tools.table.TableEpisode;
import de.p2tools.p2podder.gui.tools.table.TableRowEpisode;
import java.util.ArrayList;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class EpisodeGuiController
extends AnchorPane {
    private final SplitPane splitPane = new SplitPane();
    private final VBox vBox = new VBox(0.0);
    private final TableEpisode tableView;
    private final P2ClosePaneController infoController;
    private final PaneEpisodeInfo paneEpisodeInfo;
    private final RadioButton rbAll = new RadioButton("Alle");
    private final RadioButton rbNew = new RadioButton("Neu");
    private final RadioButton rbStarted = new RadioButton("Gestartet");
    private final RadioButton rbRunning = new RadioButton("L\u00e4uft");
    private final RadioButton rbWasShown = new RadioButton("Geh\u00f6rt");
    private final ProgData progData;
    private final BooleanProperty bound = new SimpleBooleanProperty(false);

    public EpisodeGuiController() {
        this.progData = ProgData.getInstance();
        this.tableView = new TableEpisode(Table.TABLE_ENUM.EPISODE, this.progData);
        AnchorPane.setLeftAnchor(this.splitPane, 0.0);
        AnchorPane.setBottomAnchor(this.splitPane, 0.0);
        AnchorPane.setRightAnchor(this.splitPane, 0.0);
        AnchorPane.setTopAnchor(this.splitPane, 0.0);
        this.splitPane.setOrientation(Orientation.VERTICAL);
        this.getChildren().addAll((Node[])new Node[]{this.splitPane});
        ToggleGroup tg = new ToggleGroup();
        this.rbAll.setToggleGroup(tg);
        this.rbStarted.setToggleGroup(tg);
        this.rbRunning.setToggleGroup(tg);
        this.rbWasShown.setToggleGroup(tg);
        this.rbNew.setToggleGroup(tg);
        HBox hBoxFilter = new HBox();
        hBoxFilter.setPadding(new Insets(5.0));
        hBoxFilter.setSpacing(15.0);
        hBoxFilter.getChildren().addAll((Node[])new Node[]{new Label("Episoden: "), this.rbAll, this.rbNew, this.rbStarted, this.rbRunning, this.rbWasShown});
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        scrollPane.setContent(this.tableView);
        this.vBox.getChildren().addAll((Node[])new Node[]{scrollPane, hBoxFilter});
        VBox.setVgrow(scrollPane, Priority.ALWAYS);
        this.paneEpisodeInfo = new PaneEpisodeInfo();
        P2ClosePaneDto infoDto = new P2ClosePaneDto(this.paneEpisodeInfo, ProgConfig.EPISODE__PANE_INFO_IS_RIP, ProgConfig.EPISODE__DIALOG_INFO_SIZE, ProgData.EPISODE_TAB_ON, "Info", "Beschreibung", false);
        this.infoController = new P2ClosePaneController(infoDto, ProgConfig.EPISODE__INFO_IS_SHOWING);
        ProgConfig.EPISODE__INFO_IS_SHOWING.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        ProgConfig.EPISODE__PANE_INFO_IS_RIP.addListener((observable2, oldValue, newValue) -> this.setInfoPane());
        this.setInfoPane();
        this.initFilter();
        this.initTable();
        this.initListener();
    }

    public void tableRefresh() {
        this.tableView.refresh();
    }

    public void isShown() {
        this.tableView.requestFocus();
        this.setSelectedEpisode();
    }

    public int getEpisodesShown() {
        return this.tableView.getItems().size();
    }

    private void setSelectedEpisode() {
        Episode episode = (Episode)this.tableView.getSelectionModel().getSelectedItem();
        if (episode != null) {
            this.paneEpisodeInfo.setEpisode(episode);
            this.progData.episodeInfoDialogController.setEpisode(episode);
        } else {
            this.paneEpisodeInfo.setEpisode(null);
        }
    }

    public void saveTable() {
        Table.saveTable(this.tableView, Table.TABLE_ENUM.EPISODE);
    }

    public ArrayList<Episode> getSelList() {
        ArrayList<Episode> ret = new ArrayList<Episode>();
        ret.addAll(this.tableView.getSelectionModel().getSelectedItems());
        if (ret.isEmpty()) {
            P2Alert.showInfoNoSelection();
        }
        return ret;
    }

    public Optional<Episode> getSel() {
        return this.getSel(true);
    }

    public Optional<Episode> getSel(boolean show) {
        int selectedTableRow = this.tableView.getSelectionModel().getSelectedIndex();
        if (selectedTableRow >= 0) {
            return Optional.of((Episode)this.tableView.getSelectionModel().getSelectedItem());
        }
        if (show) {
            P2Alert.showInfoNoSelection();
        }
        return Optional.empty();
    }

    public void setNextStation() {
        P2TableFactory.selectNextRow(this.tableView);
    }

    public void setPreviousStation() {
        P2TableFactory.selectPreviousRow(this.tableView);
    }

    private void initListener() {
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_SETDATA_CHANGED){

            public void pingGui(P2Event runEvent) {
                P2TableFactory.refreshTable(EpisodeGuiController.this.tableView);
            }
        });
        this.progData.pEventHandler.addListener(new P2Listener(PEvents.EVENT_REFRESH_TABLE){

            public void pingGui(P2Event runEvent) {
                P2TableFactory.refreshTable(EpisodeGuiController.this.tableView);
            }
        });
    }

    private void setInfoPane() {
        P2ClosePaneFactory.setSplit(this.bound, this.splitPane, this.infoController, false, this.vBox, ProgConfig.EPISODE__INFO_DIVIDER, ProgConfig.EPISODE__INFO_IS_SHOWING);
    }

    private void initFilter() {
        this.rbAll.selectedProperty().bindBidirectional(this.progData.episodeFilter.isAllProperty());
        this.rbNew.selectedProperty().bindBidirectional(this.progData.episodeFilter.isNewProperty());
        this.rbStarted.selectedProperty().bindBidirectional(this.progData.episodeFilter.isStartetProperty());
        this.rbRunning.selectedProperty().bindBidirectional(this.progData.episodeFilter.isRunningProperty());
        this.rbWasShown.selectedProperty().bindBidirectional(this.progData.episodeFilter.wasShownProperty());
    }

    private void initTable() {
        Table.setTable(this.tableView);
        this.tableView.setItems(this.progData.episodeList.getSortedList());
        this.progData.episodeList.getSortedList().comparatorProperty().bind(this.tableView.comparatorProperty());
        this.tableView.setOnMouseClicked(m -> {
            if (m.getButton().equals((Object)MouseButton.PRIMARY) && m.getClickCount() == 2) {
                this.progData.episodeInfoDialogController.toggleShowInfo();
            }
        });
        this.tableView.setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                Optional<Episode> optionalDownload = this.getSel(false);
                Episode episode = optionalDownload.orElse(null);
                ContextMenu contextMenu = new EpisodeGuiTableContextMenu(this.progData, this, this.tableView).getContextMenu(episode);
                this.tableView.setContextMenu(contextMenu);
            }
        });
        this.tableView.setRowFactory(new P2RowMoveFactory(tv -> {
            TableRowEpisode row = new TableRowEpisode();
            row.hoverProperty().addListener(observable2 -> {
                Episode episode = (Episode)row.getItem();
                if (row.isHover() && episode != null) {
                    this.paneEpisodeInfo.setEpisode(episode);
                    this.progData.episodeInfoDialogController.setEpisode(episode);
                } else {
                    this.setSelectedEpisode();
                }
            });
            return row;
        }));
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> this.setSelectedEpisode());
        this.tableView.getItems().addListener(c -> {
            if (this.tableView.getItems().size() == 1) {
                this.tableView.getSelectionModel().select(0);
            }
        });
        this.tableView.addEventFilter(KeyEvent.KEY_PRESSED, (? super T event) -> {
            if (P2TableFactory.SPACE.match((KeyEvent)event)) {
                P2TableFactory.scrollVisibleRangeDown(this.tableView);
                event.consume();
            }
            if (P2TableFactory.SPACE_SHIFT.match((KeyEvent)event)) {
                P2TableFactory.scrollVisibleRangeUp(this.tableView);
                event.consume();
            }
        });
    }
}

