/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui;

import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.gui.DownloadGuiController;
import de.p2tools.p2podder.gui.tools.table.TableDownload;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;

public class DownloadGuiTableContextMenu {
    private final ProgData progData;
    private final DownloadGuiController downloadGuiController;
    private final TableDownload tableView;

    public DownloadGuiTableContextMenu(ProgData progData, DownloadGuiController downloadGuiController, TableDownload tableView) {
        this.progData = progData;
        this.downloadGuiController = downloadGuiController;
        this.tableView = tableView;
    }

    public ContextMenu getContextMenu(DownloadData downloadData) {
        ContextMenu contextMenu = new ContextMenu();
        this.getMenu(contextMenu, downloadData);
        return contextMenu;
    }

    private void getMenu(ContextMenu contextMenu, DownloadData downloadData) {
        MenuItem miStart = new MenuItem("Download starten");
        miStart.setOnAction(a -> this.downloadGuiController.startDownload());
        MenuItem miStop = new MenuItem("Download stoppen");
        miStop.setOnAction(a -> this.downloadGuiController.stopDownload(false));
        MenuItem miStopAll = new MenuItem("alle Downloads stoppen");
        miStopAll.setOnAction(a -> this.downloadGuiController.stopDownload(true));
        MenuItem miCopyUrl = new MenuItem("Download (URL) kopieren");
        miCopyUrl.setOnAction(a -> this.downloadGuiController.copyUrl());
        MenuItem miChange = new MenuItem("Download \u00e4ndern");
        miChange.setOnAction(a -> this.downloadGuiController.showDownloadInfoDialog());
        MenuItem miRemove = new MenuItem("Download l\u00f6schen");
        miRemove.setOnAction(a -> this.progData.downloadGui.getDownloadGuiController().deleteDownloads(false));
        miStart.setDisable(downloadData == null);
        miStop.setDisable(downloadData == null);
        miStopAll.setDisable(downloadData == null);
        miCopyUrl.setDisable(downloadData == null);
        miChange.setDisable(downloadData == null);
        miRemove.setDisable(downloadData == null);
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{miStart, miStop, miStopAll, miCopyUrl, miChange, miRemove});
        MenuItem resetTable = new MenuItem("Tabelle zur\u00fccksetzen");
        resetTable.setOnAction(a -> this.tableView.resetTable());
        contextMenu.getItems().add(new SeparatorMenuItem());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{resetTable});
    }
}

