/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.starterepisode;

import de.p2tools.p2lib.tools.date.P2Date;
import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.controller.starterepisode.Start;
import de.p2tools.p2podder.controller.starterepisode.StartEpisodeErrorDialogController;
import de.p2tools.p2podder.controller.starterepisode.StartRuntimeExec;
import java.awt.Toolkit;
import java.util.ArrayList;
import javafx.application.Platform;

public class EpisodeStarterFactory {
    private final int stat_start = 0;
    private final int stat_running = 1;
    private final int stat_restart = 3;
    private final int stat_finished_ok = 10;
    private final int stat_finished_error = 11;
    private final int stat_end = 99;
    private final ProgData progData;
    private StarterThread starterThread;
    private Episode runningEpisode = null;

    public EpisodeStarterFactory(ProgData progData) {
        this.progData = progData;
    }

    public void startWaitingEpisodes() {
        if (this.starterThread == null || this.starterThread != null && !this.starterThread.isAlive()) {
            this.starterThread = new StarterThread();
            this.starterThread.start();
        }
    }

    public Episode getRunningEpisode() {
        return this.runningEpisode;
    }

    private class StarterThread
    extends Thread {
        private Episode episode;

        public StarterThread() {
            this.setName("Episode Daemon Thread");
            this.setDaemon(true);
        }

        @Override
        public synchronized void run() {
            try {
                while ((this.episode = EpisodeStarterFactory.this.progData.episodeStartingList.getNextStart()) != null) {
                    this.startEpisode(this.episode);
                    StarterThread.sleep(1000L);
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(903273049, ex);
            }
        }

        private void startEpisode(Episode episode) {
            EpisodeStarterFactory.this.runningEpisode = episode;
            EpisodeStarterFactory.this.progData.historyEpisodes.addHistoryDataToHistory(episode);
            Start start = episode.getStart();
            int stat = 0;
            this.refreshTable();
            try {
                while (stat < 99) {
                    stat = this.runningLoop(start, stat);
                }
            }
            catch (Exception ex) {
                String exMessage = ex.getLocalizedMessage();
                P2Log.errorLog(987989569, ex);
                if (start.getRestartCounter() == 0) {
                    Platform.runLater(() -> new StartEpisodeErrorDialogController(start, exMessage));
                }
                start.getStartStatus().setState(5);
                start.getStartStatus().setErrorMessage(exMessage);
            }
            EpisodeStarterFactory.this.runningEpisode = null;
            this.finalizePlaying(episode);
        }

        private int runningLoop(Start start, int stat) {
            switch (stat) {
                case 0: {
                    stat = this.startProgram(start);
                    break;
                }
                case 1: {
                    stat = this.runProgram(start);
                    break;
                }
                case 3: {
                    stat = this.restartProgram(start);
                    break;
                }
                case 11: {
                    start.getStartStatus().setStateError();
                    stat = 99;
                    break;
                }
                case 10: {
                    start.getStartStatus().setStateFinished();
                    stat = 99;
                }
            }
            return stat;
        }

        private int startProgram(Start start) {
            int retStat;
            start.incStartCounter();
            this.startMsg(start);
            StartRuntimeExec runtimeExec = new StartRuntimeExec(start);
            Process process = runtimeExec.exec();
            start.setProcess(process);
            if (process != null) {
                start.getStartStatus().setStateRunning();
                retStat = 1;
            } else {
                retStat = 3;
            }
            return retStat;
        }

        private int runProgram(Start start) {
            int retStatus = 1;
            try {
                if (start.getStartStatus().isStateStopped()) {
                    retStatus = 10;
                    if (start.getProcess() != null) {
                        start.getProcess().destroy();
                    }
                } else {
                    int exitV = start.getProcess().exitValue();
                    retStatus = exitV != 0 ? 3 : 10;
                }
            }
            catch (Exception ex) {
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return retStatus;
        }

        private int restartProgram(Start start) {
            int retStatus = start.getStartCounter() < 3 ? 0 : 11;
            return retStatus;
        }

        private void startMsg(Start starter) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add("------------------------------------------------------------");
            list.add("Episode abspielen");
            list.add("URL: " + starter.getFilePathName());
            list.add("Startzeit: " + P2DateConst.F_FORMAT_HH__mm__ss.format(starter.getStartTime()));
            list.add("Programmaufruf: " + starter.getProgramCall());
            list.add("Programmaufruf[]: " + starter.getProgramCallArray());
            list.add("  ");
            P2Log.sysLog(list.toArray(new String[list.size()]));
        }

        private void finalizePlaying(Episode episode) {
            Start start = episode.getStart();
            this.finishedMsg(start);
            start.setProcess(null);
            episode.setStart(null);
            this.refreshTable();
        }

        private void finishedMsg(Start start) {
            long dauer;
            if (ProgConfig.DOWNLOAD_BEEP.get()) {
                try {
                    Toolkit.getDefaultToolkit().beep();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add("------------------------------------------------------------");
            list.add("Episode abspielen beendet");
            list.add("Startzeit: " + P2DateConst.F_FORMAT_HH__mm__ss.format(start.getStartTime()));
            list.add("Endzeit: " + P2DateConst.F_FORMAT_HH__mm__ss.format(new P2Date().getTime()));
            if (start.getRestartCounter() > 0) {
                list.add("Restarts: " + start.getRestartCounter());
            }
            if ((dauer = (long)start.getStartTime().diffInMinutes()) == 0L) {
                list.add("Dauer: " + start.getStartTime().diffInSeconds() + " s");
            } else {
                list.add("Dauer: " + start.getStartTime().diffInMinutes() + " Min");
            }
            list.add("URL: " + start.getFilePathName());
            list.add("Programmaufruf: " + start.getProgramCall());
            list.add("Programmaufruf[]: " + start.getProgramCallArray());
            list.add("  ");
            P2Log.sysLog(list);
        }

        private void refreshTable() {
            ProgData.getInstance().episodeGui.getEpisodeGuiController().tableRefresh();
            if (ProgData.getInstance().smallGuiPack != null) {
                ProgData.getInstance().smallGuiPack.tableRefresh();
            }
        }
    }
}

