/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.starterdownload;

import de.p2tools.p2lib.configfile.config.Config;
import de.p2tools.p2lib.mediathek.tools.P2SizeTools;
import de.p2tools.p2lib.tools.date.P2Date;
import de.p2tools.p2podder.controller.data.SetData;
import de.p2tools.p2podder.controller.data.download.DownloadConstants;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.controller.starterepisode.StartProps;
import de.p2tools.p2podder.controller.starterepisode.StartStatus;
import de.p2tools.p2podder.tools.MLInputStream;

public final class DownloadStart
extends StartProps {
    private final StartStatus startStatus = new StartStatus();
    private int restartCounter = 0;
    private long bandwidth = -1L;
    private long timeLeftSeconds = -1L;
    private MLInputStream inputStream = null;
    private P2Date startTime = null;
    private Process process = null;
    private DownloadData downloadData = null;
    private SetData setData = null;

    public DownloadStart() {
    }

    public DownloadStart(DownloadData downloadData) {
        this.downloadData = downloadData;
    }

    public long getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
        this.downloadData.setBandwidth(P2SizeTools.humanReadableByteCount(bandwidth, true));
    }

    public P2Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(P2Date startTime) {
        this.startTime = startTime;
    }

    public StartStatus getStartStatus() {
        return this.startStatus;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public MLInputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(MLInputStream inputStream2) {
        this.inputStream = inputStream2;
    }

    public void startDownload() {
        this.setStartTime(new P2Date());
    }

    public void setRestartCounter(int restartCounter) {
        this.restartCounter = restartCounter;
    }

    public int getRestartCounter() {
        return this.restartCounter;
    }

    public long getTimeLeftSeconds() {
        return this.timeLeftSeconds;
    }

    public void setTimeLeftSeconds(long timeLeftSeconds) {
        this.timeLeftSeconds = timeLeftSeconds;
        if (this.downloadData.isStateStartedRun() && this.getTimeLeftSeconds() > 0L) {
            this.downloadData.setRemaining(DownloadConstants.getTimeLeft(timeLeftSeconds));
        } else {
            this.downloadData.setRemaining("");
        }
    }

    public DownloadStart getCopy() {
        DownloadStart ret = new DownloadStart();
        ret.setData = this.setData;
        Config[] configs = this.getConfigsArr();
        Config[] configsCopy = ret.getConfigsArr();
        for (int i = 0; i < configs.length; ++i) {
            configsCopy[i].setActValue(configs[i].getActValueString());
        }
        return ret;
    }

    public void copyToMe(DownloadStart start) {
        this.setData = start.setData;
        Config[] configs = start.getConfigsArr();
        Config[] configsCopy = this.getConfigsArr();
        for (int i = 0; i < configs.length; ++i) {
            configsCopy[i].setActValue(configs[i].getActValueString());
        }
    }
}

