/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.starterdownload;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.config.ProgInfosFactory;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.controller.starterdownload.DownloadStarterFactory;
import de.p2tools.p2podder.tools.MLInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Timer;
import javafx.application.Platform;
import javax.net.ssl.HttpsURLConnection;

public class DirectHttpDownload
extends Thread {
    private static final int TIMEOUT_LENGTH = 3000;
    private final ProgData progData;
    private final DownloadData download;
    private HttpURLConnection conn = null;
    private long downloaded = 0L;
    private File file = null;
    private String responseCode;
    private String exMessage;
    private FileOutputStream fos = null;
    private final Timer bandwidthCalculationTimer;
    private boolean retBreak;
    private boolean dialogBreakIsVis;

    public DirectHttpDownload(ProgData progData, DownloadData d, Timer bandwidthCalculationTimer) {
        this.progData = progData;
        this.bandwidthCalculationTimer = bandwidthCalculationTimer;
        this.download = d;
        this.setName("DIRECT DL THREAD: " + d.getEpisodeTitle());
        this.download.setStateStartedRun();
    }

    @Override
    public synchronized void run() {
        DownloadStarterFactory.startMsg(this.download);
        try {
            Files.createDirectories(Paths.get(this.download.getDestPath(), new String[0]), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int restartCount = 0;
        boolean restart = true;
        while (restart) {
            restart = false;
            try {
                URL url = new URL(this.download.getEpisodeUrl());
                this.file = new File(this.download.getDestPathFile());
                if (!this.cancelDownload()) {
                    this.download.getDownloadSize().setTargetSize(this.getContentLength(url));
                    this.download.getDownloadSize().setActuallySize(0L);
                    this.conn = (HttpURLConnection)url.openConnection();
                    this.conn.setConnectTimeout(1000 * ProgConfig.SYSTEM_PARAMETER_DOWNLOAD_TIMEOUT_SECOND.getValue());
                    this.conn.setReadTimeout(1000 * ProgConfig.SYSTEM_PARAMETER_DOWNLOAD_TIMEOUT_SECOND.getValue());
                    if (ProgConfig.SYSTEM_SSL_ALWAYS_TRUE.getValue().booleanValue() && this.conn instanceof HttpsURLConnection) {
                        HttpsURLConnection httpsConn = (HttpsURLConnection)this.conn;
                        httpsConn.setHostnameVerifier((hostname, session) -> true);
                    }
                    this.setupHttpConnection(this.conn);
                    this.conn.connect();
                    int httpResponseCode = this.conn.getResponseCode();
                    if (httpResponseCode >= 400) {
                        if (httpResponseCode == 416) {
                            this.conn.disconnect();
                            this.conn = (HttpURLConnection)url.openConnection();
                            this.downloaded = 0L;
                            this.setupHttpConnection(this.conn);
                            this.conn.connect();
                            if (this.conn.getResponseCode() >= 400) {
                                this.download.setStateError();
                            }
                        } else {
                            this.responseCode = "Responsecode: " + this.conn.getResponseCode() + P2LibConst.LINE_SEPARATOR + this.conn.getResponseMessage();
                            P2Log.errorLog(915236798, "HTTP-Fehler: " + this.conn.getResponseCode() + " " + this.conn.getResponseMessage());
                            this.download.setErrorMessage(this.responseCode);
                            this.download.setStateError();
                        }
                    }
                }
                if (!this.download.isStateStartedRun()) continue;
                this.downloadContent();
            }
            catch (Exception ex) {
                if (ex instanceof IOException && restartCount < ProgConfig.SYSTEM_PARAMETER_DOWNLOAD_MAX_RESTART_HTTP.getValue()) {
                    if (ex instanceof SocketTimeoutException) {
                        ArrayList<CallSite> text = new ArrayList<CallSite>();
                        text.add((CallSite)((Object)("Timeout, Download Restarts: " + restartCount)));
                        text.add((CallSite)((Object)("Ziel: " + this.download.getDestPathFile())));
                        text.add((CallSite)((Object)("URL: " + this.download.getEpisodeUrl())));
                        P2Log.sysLog(text.toArray(new String[text.size()]));
                    }
                    ++restartCount;
                    restart = true;
                    continue;
                }
                this.exMessage = ex.getMessage();
                P2Log.errorLog(316598941, ex, "Fehler");
                this.download.setErrorMessage(this.exMessage);
                this.download.setStateError();
            }
        }
        try {
            if (this.download.getDownloadStart().getInputStream() != null) {
                this.download.getDownloadStart().getInputStream().close();
            }
            if (this.fos != null) {
                this.fos.close();
            }
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DownloadStarterFactory.finalizeDownload(this.download);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getContentLength(URL url) {
        long ret = -1L;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", ProgInfosFactory.getUserAgent());
            connection.setReadTimeout(3000);
            connection.setConnectTimeout(3000);
            if (connection.getResponseCode() < 400) {
                ret = connection.getContentLengthLong();
            }
            if (ret < 300000L) {
                ret = -1L;
            }
        }
        catch (Exception ex) {
            ret = -1L;
            P2Log.errorLog(643298301, ex);
        }
        finally {
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        return ret;
    }

    private void setupHttpConnection(HttpURLConnection conn) {
        conn.setRequestProperty("Range", "bytes=" + this.downloaded + "-");
        conn.setRequestProperty("User-Agent", ProgInfosFactory.getUserAgent());
        conn.setDoInput(true);
        conn.setDoOutput(true);
    }

    private void downloadContent() throws Exception {
        int len;
        this.download.getDownloadStart().setInputStream(new MLInputStream(this.conn.getInputStream(), this.bandwidthCalculationTimer, ProgConfig.DOWNLOAD_MAX_BANDWIDTH_KBYTE));
        this.fos = new FileOutputStream(this.file, this.downloaded != 0L);
        this.download.getDownloadSize().addActFileSize(this.downloaded);
        byte[] buffer = new byte[4096];
        double ppercent = 0.0;
        double startPercent = -1.0;
        long aktBandwidth = 0L;
        long aktSize = 0L;
        while ((len = this.download.getDownloadStart().getInputStream().read(buffer)) != -1 && !this.download.isStateStopped()) {
            this.downloaded += (long)len;
            this.fos.write(buffer, 0, len);
            this.download.getDownloadSize().addActFileSize(len);
            if (aktSize != this.download.getDownloadSize().getActuallySize()) {
                aktSize = this.download.getDownloadSize().getActuallySize();
            }
            if (this.download.getDownloadSize().getTargetSize() > 0L) {
                double percent = 1.0 * (double)aktSize / (double)this.download.getDownloadSize().getTargetSize();
                if (startPercent == -1.0) {
                    startPercent = percent;
                }
                if (percent == 0.0) {
                    percent = 0.001;
                } else if (percent >= 1.0) {
                    percent = 0.995;
                }
                this.download.setProgress(percent);
                if (percent != ppercent) {
                    ppercent = percent;
                    if (percent > 0.001 && percent > startPercent) {
                        long timeLeft = 0L;
                        long sizeLeft = this.download.getDownloadSize().getTargetSize() - this.download.getDownloadSize().getActuallySize();
                        if (sizeLeft <= 0L) {
                            timeLeft = 0L;
                        } else if (aktBandwidth > 0L) {
                            timeLeft = sizeLeft / aktBandwidth;
                        }
                        this.download.getDownloadStart().setTimeLeftSeconds(timeLeft);
                    }
                }
            }
            if ((aktBandwidth = this.download.getDownloadStart().getInputStream().getBandwidth()) == this.download.getDownloadStart().getBandwidth()) continue;
            this.download.getDownloadStart().setBandwidth(aktBandwidth);
        }
        if (!this.download.isStateStopped()) {
            if (DownloadStarterFactory.check(this.progData, this.download)) {
                this.download.setStateFinished();
            } else {
                this.download.setStateError();
            }
        }
    }

    private boolean cancelDownload() {
        if (!this.file.exists()) {
            return false;
        }
        this.dialogBreakIsVis = true;
        this.retBreak = true;
        Platform.runLater(() -> {
            this.retBreak = this.break_();
            this.dialogBreakIsVis = false;
        });
        while (this.dialogBreakIsVis) {
            try {
                this.wait(100L);
            }
            catch (Exception exception) {}
        }
        return this.retBreak;
    }

    private boolean break_() {
        return false;
    }
}

