/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.filter;

import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import de.p2tools.p2podder.controller.filter.Filter;
import de.p2tools.p2podder.controller.filter.FilterCheck;
import java.util.Locale;
import java.util.function.Predicate;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class PodcastFilter {
    private StringProperty genre = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private StringProperty url = new SimpleStringProperty("");

    public PodcastFilter() {
        this.genre.addListener((observable2, oldValue, newValue) -> this.setPredicate());
        this.name.addListener((observable2, oldValue, newValue) -> this.setPredicate());
        this.url.addListener((observable2, oldValue, newValue) -> this.setPredicate());
    }

    public void clearFilter() {
        this.genre.setValue("");
        this.name.setValue("");
        this.url.setValue("");
        this.setPredicate();
    }

    public void setGenre(String genre) {
        if (genre == null) {
            genre = "";
        }
        this.genre.setValue(genre);
        this.setPredicate();
    }

    public StringProperty genreProperty() {
        return this.genre;
    }

    public void setName(String name) {
        this.name.setValue(name.trim().toLowerCase(Locale.ROOT));
        this.setPredicate();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public void setUrl(String url) {
        this.url.setValue(url.trim().toLowerCase(Locale.ROOT));
        this.setPredicate();
    }

    public StringProperty urlProperty() {
        return this.url;
    }

    private Predicate<Podcast> getPredicate() {
        Predicate<Podcast> predicate = podcast -> true;
        if (!this.genre.getValueSafe().isEmpty()) {
            predicate = predicate.and(podcast -> podcast.genreProperty().getValue().equals(this.genre.getValueSafe()));
        }
        if (!this.name.getValueSafe().isEmpty()) {
            predicate = predicate.and(podcast -> FilterCheck.checkString(new Filter(this.name.getValueSafe(), true), podcast.getName()));
        }
        if (!this.url.getValueSafe().isEmpty()) {
            predicate = predicate.and(podcast -> FilterCheck.checkString(new Filter(this.url.getValueSafe(), true), podcast.getUrl()));
        }
        return predicate;
    }

    private void setPredicate() {
        ProgData.getInstance().podcastList.filteredListSetPred(this.getPredicate());
    }
}

