/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.filter;

import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.controller.data.episode.EpisodeFactory;
import de.p2tools.p2podder.controller.filter.EpisodeFilterSmallProps;
import java.util.function.Predicate;

public class EpisodeFilterSmall
extends EpisodeFilterSmallProps {
    public EpisodeFilterSmall() {
        this.initFilter();
    }

    public void clearFilter() {
        this.setPodcastId(0L);
    }

    private void initFilter() {
        this.podcastIdProperty().addListener(l -> this.setPredicate());
        this.isAllProperty().addListener(l -> this.setPredicate());
        this.isNewProperty().addListener(l -> this.setPredicate());
        this.isStartedProperty().addListener(l -> this.setPredicate());
        this.isRunningProperty().addListener(l -> this.setPredicate());
        this.wasShownProperty().addListener(l -> this.setPredicate());
    }

    public void setPredicate() {
        ProgData.getInstance().episodeList.smallFilteredListSetPred(this.getPredicateEpisode());
    }

    private Predicate<Episode> getPredicateEpisode() {
        Predicate<Episode> predicate = episode -> true;
        if (this.getPodcastId() > 0L) {
            predicate = predicate.and(episode -> episode.podcastIdProperty().getValue().equals(this.getPodcastId()));
        }
        if (this.isIsNew()) {
            predicate = predicate.and(episode -> episode.isNew());
        }
        if (this.isIsStarted()) {
            predicate = predicate.and(episode -> EpisodeFactory.episodeIsStarted(episode));
        }
        if (this.isIsRunning()) {
            predicate = predicate.and(episode -> EpisodeFactory.episodeIsRunning(episode));
        }
        if (this.isWasShown()) {
            predicate = predicate.and(episode -> ProgData.getInstance().historyEpisodes.checkIfUrlAlreadyIn(episode.getEpisodeUrl()));
        }
        return predicate;
    }
}

