/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.filter;

import de.p2tools.p2lib.tools.date.P2DateFactory;
import de.p2tools.p2podder.controller.filter.EpisodeFilter;
import de.p2tools.p2podder.controller.filter.EpisodeFilterFactory;
import java.util.Date;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public final class EpisodeFilterForwardBackward {
    private final EpisodeFilter actFilter;
    private final BooleanProperty backward = new SimpleBooleanProperty(false);
    private final BooleanProperty forward = new SimpleBooleanProperty(false);
    private boolean stopInput = false;
    private int idx = 0;
    private Date date = new Date();
    private final ObservableList<EpisodeFilter> filterListBackward = FXCollections.observableArrayList();

    public EpisodeFilterForwardBackward(EpisodeFilter actFilter) {
        this.actFilter = actFilter;
        this.filterListBackward.add(new EpisodeFilter());
        this.filterListBackward.addListener(c -> this.setIdx(this.filterListBackward.size() - 1));
    }

    public BooleanProperty backwardProperty() {
        return this.backward;
    }

    public BooleanProperty forwardProperty() {
        return this.forward;
    }

    public void addNewFilter() {
        if (this.stopInput) {
            return;
        }
        while (this.filterListBackward.size() > 25) {
            this.filterListBackward.remove(0);
        }
        if (this.filterListBackward.isEmpty()) {
            this.filterListBackward.add(EpisodeFilterFactory.copyFilter(this.actFilter, new EpisodeFilter()));
            return;
        }
        EpisodeFilter ep = (EpisodeFilter)this.filterListBackward.get(this.filterListBackward.size() - 1);
        if (!EpisodeFilterFactory.compareFilter(this.actFilter, ep)) {
            if (this.checkIsTheSame(ep, this.actFilter)) {
                this.filterListBackward.remove(this.filterListBackward.size() - 1);
                this.filterListBackward.add(EpisodeFilterFactory.copyFilter(this.actFilter, new EpisodeFilter(false)));
            } else {
                this.filterListBackward.add(EpisodeFilterFactory.copyFilter(this.actFilter, new EpisodeFilter()));
                this.setIdx(this.filterListBackward.size() - 1);
            }
        }
    }

    public void goBackward() {
        this.go(true);
    }

    public void goForward() {
        this.go(false);
    }

    private boolean checkIsTheSame(EpisodeFilter ep, EpisodeFilter act) {
        if (P2DateFactory.diffInSeconds(this.date) > 3) {
            return false;
        }
        this.date = new Date();
        if (ep.getPodcastId() != act.getPodcastId()) {
            return false;
        }
        if (!ep.getGenre().equals(act.getGenre())) {
            return false;
        }
        if (!ep.getTitle().equals(act.getTitle())) {
            return !ep.getTitle().isEmpty() && !act.getTitle().isEmpty();
        }
        if (!ep.getDescription().equals(act.getDescription())) {
            return !ep.getDescription().isEmpty() && !act.getDescription().isEmpty();
        }
        if (ep.getTimeRange() != act.getTimeRange()) {
            return ep.getTimeRange() != 0 && act.getTimeRange() != 0;
        }
        if (ep.getDurationMin() != act.getDurationMin()) {
            return ep.getDurationMin() != 0 && act.getDurationMin() != 100;
        }
        if (ep.getDurationMax() != act.getDurationMax()) {
            return ep.getDurationMax() != 0 && act.getDurationMax() != 100;
        }
        return false;
    }

    private void go(boolean back) {
        if (this.filterListBackward.isEmpty()) {
            this.checkButton();
            return;
        }
        if (back) {
            if (this.idx >= this.filterListBackward.size()) {
                this.setIdx(this.filterListBackward.size() - 1);
            }
        } else if (this.idx <= 0) {
            this.setIdx(0);
        }
        while (back ? this.idx >= 0 : this.idx < this.filterListBackward.size()) {
            EpisodeFilter ep = (EpisodeFilter)this.filterListBackward.get(this.idx);
            if (EpisodeFilterFactory.compareFilter(this.actFilter, ep)) {
                int n;
                if (back) {
                    n = this.idx - 1;
                    this.idx = this.idx;
                } else {
                    n = this.idx + 1;
                    this.idx = this.idx;
                }
                this.setIdx(n);
                continue;
            }
            this.stopInput = true;
            this.setActFilterSettings(ep);
            this.stopInput = false;
            break;
        }
        this.checkButton();
    }

    private void setIdx(int i) {
        this.idx = i;
        this.checkButton();
    }

    private void checkButton() {
        this.backward.setValue(this.checkBackward());
        this.forward.setValue(this.checkForward());
    }

    private boolean checkBackward() {
        if (this.idx == 0) {
            return false;
        }
        return this.check();
    }

    private boolean checkForward() {
        if (this.idx >= this.filterListBackward.size() - 1) {
            return false;
        }
        return this.check();
    }

    private boolean check() {
        if (this.filterListBackward.isEmpty()) {
            return false;
        }
        if (this.filterListBackward.size() == 1) {
            return !EpisodeFilterFactory.compareFilter(this.actFilter, (EpisodeFilter)this.filterListBackward.get(0));
        }
        return true;
    }

    private void setActFilterSettings(EpisodeFilter sf) {
        EpisodeFilterFactory.copyFilter(sf, this.actFilter);
        this.actFilter.setPredicate(false);
    }
}

