/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.filter;

import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.controller.filter.Filter;
import de.p2tools.p2podder.controller.filter.FilterCheck;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class DownloadFilter {
    private final LongProperty podcastId = new SimpleLongProperty(0L);
    private final StringProperty genre = new SimpleStringProperty("");
    private final StringProperty title = new SimpleStringProperty("");
    private final BooleanProperty isAll = new SimpleBooleanProperty(true);
    private final BooleanProperty isStarted = new SimpleBooleanProperty(false);
    private final BooleanProperty isLoading = new SimpleBooleanProperty(false);
    private final BooleanProperty isFinalized = new SimpleBooleanProperty(false);
    private boolean running = false;
    private boolean loading = false;
    private boolean finalized = false;

    public DownloadFilter() {
        this.podcastId.addListener((observable2, oldValue, newValue) -> this.setPredicate());
        this.genre.addListener((observable2, oldValue, newValue) -> this.setPredicate());
        this.title.addListener((observable2, oldValue, newValue) -> this.setPredicate());
        this.isAll.addListener((observable2, oldValue, newValue) -> {
            this.running = false;
            this.loading = false;
            this.finalized = false;
            this.setPredicate();
        });
        this.isStarted.addListener((observable2, oldValue, newValue) -> {
            this.running = true;
            this.loading = false;
            this.finalized = false;
            this.setPredicate();
        });
        this.isLoading.addListener((observable2, oldValue, newValue) -> {
            this.running = false;
            this.loading = true;
            this.finalized = false;
            this.setPredicate();
        });
        this.isFinalized.addListener((observable2, oldValue, newValue) -> {
            this.running = false;
            this.loading = false;
            this.finalized = true;
            this.setPredicate();
        });
    }

    public void setPodcastId(long podcastId) {
        this.podcastId.setValue(podcastId);
        this.setPredicate();
    }

    public LongProperty podcastIdProperty() {
        return this.podcastId;
    }

    public StringProperty genreProperty() {
        return this.genre;
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public BooleanProperty isAllProperty() {
        return this.isAll;
    }

    public BooleanProperty isStartedProperty() {
        return this.isStarted;
    }

    public BooleanProperty isLoadingProperty() {
        return this.isLoading;
    }

    public BooleanProperty isFinalizedProperty() {
        return this.isFinalized;
    }

    public void setPredicate() {
        ProgData.getInstance().downloadList.filteredListSetPred(this.getPredicate());
    }

    public void clearFilter() {
        this.podcastId.setValue(0);
        this.genre.setValue("");
        this.title.setValue("");
        this.setPredicate();
    }

    private Predicate<DownloadData> getPredicate() {
        Predicate<DownloadData> predicate = download -> true;
        if (this.podcastId.getValue() > 0L) {
            predicate = predicate.and(download -> download.getPodcastId() == this.podcastId.getValue().longValue());
        }
        if (!this.genre.getValueSafe().isEmpty()) {
            predicate = predicate.and(download -> download.genreProperty().getValue().equals(this.genre.getValueSafe()));
        }
        if (!this.title.getValueSafe().isEmpty()) {
            predicate = predicate.and(download -> FilterCheck.checkString(new Filter(this.title.getValueSafe(), true), download.getEpisodeTitle()));
        }
        if (this.running) {
            predicate = predicate.and(download -> download.isStarted());
        }
        if (this.loading) {
            predicate = predicate.and(download -> download.isStateStartedRun());
        }
        if (this.finalized) {
            predicate = predicate.and(download -> download.isStateFinalized());
        }
        return predicate;
    }
}

