/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.data.episode;

import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.P2ToolsFactory;
import de.p2tools.p2lib.tools.file.P2FileUtils;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.SetData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import de.p2tools.p2podder.controller.starterepisode.Start;
import de.p2tools.p2podder.gui.dialog.EpisodeDelDialogController;
import de.p2tools.p2podder.gui.dialog.NoSetDialogController;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.stage.Stage;

public class EpisodeFactory {
    public static Optional<Episode> getSel() {
        if (ProgData.getInstance().smallGuiPack == null) {
            return ProgData.getInstance().episodeGui.getEpisodeGuiController().getSel();
        }
        return ProgData.getInstance().smallGuiPack.getSel();
    }

    public static ArrayList<Episode> getSelList() {
        if (ProgData.getInstance().smallGuiPack == null) {
            return ProgData.getInstance().episodeGui.getEpisodeGuiController().getSelList();
        }
        return ProgData.getInstance().smallGuiPack.getSelList();
    }

    public static void refreshTable() {
        if (ProgData.getInstance().smallGuiPack == null) {
            ProgData.getInstance().episodeGui.getEpisodeGuiController().tableRefresh();
        } else {
            ProgData.getInstance().smallGuiPack.tableRefresh();
        }
    }

    public static boolean episodeIsStarted(Episode episode) {
        return episode.getStart() != null;
    }

    public static boolean episodeIsRunning(Episode episode) {
        return episode.getStart() != null && episode.getStart().getStartStatus().isStatedRunning();
    }

    public static long countEpisode(Podcast podcast) {
        return ProgData.getInstance().episodeList.stream().filter(p -> p.getPodcastId() == podcast.getId()).count();
    }

    public static void copyUrl() {
        Optional<Episode> episode = EpisodeFactory.getSel();
        if (episode.isPresent()) {
            return;
        }
        P2ToolsFactory.copyToClipboard(episode.get().getEpisodeUrl());
    }

    public static void playSelEpisode() {
        EpisodeFactory.playEpisode(EpisodeFactory.getSelList(), null);
    }

    public static void playEpisode(SetData setData) {
        Optional<Episode> episode = EpisodeFactory.getSel();
        if (episode.isPresent()) {
            EpisodeFactory.playEpisode(episode.get(), setData);
        }
    }

    public static void playEpisode() {
        Optional<Episode> episode = EpisodeFactory.getSel();
        if (episode.isPresent()) {
            EpisodeFactory.playEpisode(episode.get());
        }
    }

    public static void playEpisode(Episode episode) {
        EpisodeFactory.playEpisode(episode, null);
    }

    public static void playEpisode(Episode episode, SetData setData) {
        if (setData == null) {
            setData = ProgData.getInstance().setDataList.getSetDataPlay();
        }
        if (setData == null) {
            new NoSetDialogController(ProgData.getInstance());
            return;
        }
        EpisodeFactory.startFileWithProgram(episode, setData);
    }

    public static void playEpisode(List<Episode> episodeList, SetData setData) {
        if (setData == null) {
            setData = ProgData.getInstance().setDataList.getSetDataPlay();
        }
        if (setData == null) {
            new NoSetDialogController(ProgData.getInstance());
            return;
        }
        EpisodeFactory.startFileWithProgram(episodeList, setData);
    }

    public static void stopEpisode() {
        Optional<Episode> episode = EpisodeFactory.getSel();
        if (episode.isPresent()) {
            EpisodeFactory.stopEpisode(episode.get());
        }
    }

    public static void stopEpisode(Episode episode) {
        if (EpisodeFactory.episodeIsStarted(episode)) {
            if (episode.getStart().getStartStatus().isStatedRunning()) {
                episode.getStart().getStartStatus().setStateStopped();
                episode.getStart().setNo(Integer.MAX_VALUE);
            } else if (episode.getStart().getStartStatus().isStateInit()) {
                episode.setStart(null);
            }
        }
    }

    public static void playNextEpisode() {
        EpisodeFactory.playNextEpisode(ProgData.getInstance().primaryStage);
    }

    public static void playNextEpisode(Stage stage) {
        EpisodeFactory.stopRunningEpisode();
        if (ProgData.getInstance().episodeStartingList.isEmpty()) {
            P2Alert.showErrorAlert(stage, "Keine Episoden", "Es sind keine weiteren Episoden gestartet");
        }
    }

    public static void stopRunningEpisode() {
        if (ProgData.getInstance().episodeStarterFactory.getRunningEpisode() != null) {
            EpisodeFactory.stopEpisode(ProgData.getInstance().episodeStarterFactory.getRunningEpisode());
        }
    }

    public static void stopAllEpisode() {
        if (ProgData.getInstance().episodeStarterFactory.getRunningEpisode() != null) {
            EpisodeFactory.stopEpisode(ProgData.getInstance().episodeStarterFactory.getRunningEpisode());
        }
        ProgData.getInstance().episodeList.stream().forEach(episode -> EpisodeFactory.stopEpisode(episode));
        ProgData.getInstance().episodeStartingList.clear();
    }

    public static void delEpisode() {
        Optional<Episode> episode = EpisodeFactory.getSel();
        if (episode.isPresent()) {
            EpisodeFactory.delEpisode(episode.get());
        }
    }

    public static void delEpisode(Episode episode) {
        ArrayList<Episode> delList = new ArrayList<Episode>();
        delList.add(episode);
        EpisodeFactory.delEpisodes(delList);
    }

    public static void delAllShownEpisodes() {
        ArrayList<Episode> delList = new ArrayList<Episode>();
        ProgData.getInstance().episodeList.stream().forEach(episode -> {
            if (ProgData.getInstance().historyEpisodes.checkIfUrlAlreadyIn(episode.getEpisodeUrl())) {
                delList.add((Episode)episode);
            }
        });
        EpisodeFactory.delEpisodes(delList);
    }

    public static void delSelEpisode() {
        EpisodeFactory.delEpisodes(EpisodeFactory.getSelList());
    }

    private static void delEpisodes(List<Episode> episodeList) {
        if (!ProgConfig.SYSTEM_DELETE_EPISODE_FILE_ASK.getValue().booleanValue()) {
            EpisodeFactory.delEpisodeAndFiles(episodeList);
            return;
        }
        EpisodeDelDialogController episodeDelDialogController = new EpisodeDelDialogController(ProgData.getInstance(), episodeList);
        if (episodeDelDialogController.isOk()) {
            EpisodeFactory.delEpisodeAndFiles(episodeList);
        }
    }

    private static void delEpisodeAndFiles(List<Episode> delList) {
        delList.stream().forEach(episode -> ProgData.getInstance().episodeList.remove(episode));
        if (ProgConfig.SYSTEM_DELETE_EPISODE_FILE.getValue().booleanValue()) {
            delList.stream().forEach(episode -> {
                String path = P2FileUtils.addsPath(episode.getFilePath(), episode.getFileName());
                File file = new File(path);
                try {
                    if (file.exists()) {
                        P2Log.sysLog("Episode (Datei) l\u00f6schen: " + file.getAbsolutePath());
                        if (!file.delete()) {
                            throw new Exception();
                        }
                    }
                }
                catch (Exception ex) {
                    P2Log.errorLog(915200147, "Fehler beim l\u00f6schen: " + file.getAbsolutePath());
                }
            });
        }
    }

    private static synchronized void startFileWithProgram(Episode episode, SetData setData) {
        String pathName = P2FileUtils.addsPath(episode.getFilePath(), episode.getFileName());
        if (episode.getFilePath().isEmpty() || episode.getFileName().isEmpty()) {
            return;
        }
        if (!P2FileUtils.fileExist(pathName)) {
            P2Alert.showErrorAlert(ProgData.getInstance().primaryStage, "Episode abspielen", "Die Datei: \n" + pathName + "\nexistiert nicht mehr!");
            return;
        }
        if (!ProgData.getInstance().episodeStartingList.contains(episode) && episode.getStart() == null) {
            Start start = new Start(setData, episode);
            episode.setStart(start);
            ProgData.getInstance().episodeStartingList.add(episode);
        }
        ProgData.getInstance().episodeStarterFactory.startWaitingEpisodes();
        EpisodeFactory.refreshTable();
    }

    private static synchronized void startFileWithProgram(List<Episode> episodeList, SetData setData) {
        episodeList.stream().forEach(episode -> {
            String pathName = P2FileUtils.addsPath(episode.getFilePath(), episode.getFileName());
            if (episode.getFilePath().isEmpty() || episode.getFileName().isEmpty()) {
                return;
            }
            if (!P2FileUtils.fileExist(pathName)) {
                P2Alert.showErrorAlert(ProgData.getInstance().primaryStage, "Episode abspielen", "Die Datei: \n" + pathName + "\nexistiert nicht mehr!");
                return;
            }
            if (!ProgData.getInstance().episodeStartingList.contains(episode) && episode.getStart() == null) {
                Start start = new Start(setData, (Episode)episode);
                episode.setStart(start);
                ProgData.getInstance().episodeStartingList.add((Episode)episode);
            }
        });
        ProgData.getInstance().episodeStarterFactory.startWaitingEpisodes();
        EpisodeFactory.refreshTable();
    }
}

