/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.data.episode;

import de.p2tools.p2lib.configfile.config.Config;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.controller.data.episode.EpisodeProps;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import de.p2tools.p2podder.controller.starterepisode.Start;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

public final class Episode
extends EpisodeProps {
    private Start start = null;
    private boolean isNew = false;

    public Episode() {
    }

    public Episode(DownloadData download) {
        Podcast podcast = ProgData.getInstance().podcastList.getPodcastById(download.getPodcastId());
        this.setDurationInt(download.getDurationInt());
        this.setDescription(download.getDescription());
        this.setEpisodeWebsite(download.getEpisodeWebsite());
        this.setEpisodeUrl(download.getEpisodeUrl());
        this.setPodcastId(download.getPodcastId());
        this.setEpisodeTitle(download.getEpisodeTitle());
        this.setGenre(download.getGenre());
        this.setFileName(download.getDestFileName());
        this.setFilePath(download.getDestPath());
        this.getPFileSize().setSizeL(download.getDownloadSize().getTargetSize());
        this.setPubDate(download.getPubDate());
        if (podcast != null) {
            this.setPodcastName(podcast.getName());
        }
        this.setNew(true);
    }

    public Start getStart() {
        return this.start;
    }

    public void setStart(Start start) {
        this.start = start;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean aNew) {
        this.isNew = aNew;
    }

    public boolean checkDays(long days) {
        if (this.getPubDate().isEqual(LocalDate.MIN)) {
            return true;
        }
        long timeRange = ChronoUnit.DAYS.between(this.getPubDate(), LocalDate.now());
        return timeRange <= days;
    }

    public boolean checkDurationMin(long minute) {
        if (this.getDurationInt() == 0) {
            return true;
        }
        return (long)this.getDurationInt() > minute * 60L;
    }

    public boolean checkDurationMax(long minutes) {
        if (this.getDurationInt() == 100) {
            return true;
        }
        return (long)this.getDurationInt() < minutes * 60L;
    }

    public void setThePodcast(Podcast podcast) {
        if (podcast == null) {
            return;
        }
        this.setPodcastId(podcast.getId());
    }

    public Episode getCopy() {
        Episode ret = new Episode();
        ret.start = this.start;
        Config[] configs = this.getConfigsArr();
        Config[] configsCopy = ret.getConfigsArr();
        for (int i = 0; i < configs.length; ++i) {
            configsCopy[i].setActValue(configs[i].getActValueString());
        }
        return ret;
    }

    public void copyToMe(Episode episode) {
        this.start = episode.start;
        Config[] configs = episode.getConfigsArr();
        Config[] configsCopy = this.getConfigsArr();
        for (int i = 0; i < configs.length; ++i) {
            configsCopy[i].setActValue(configs[i].getActValueString());
        }
    }
}

