/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.data.download;

import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.controller.data.download.DownloadList;
import java.net.URL;

public class DownloadListStartFactory {
    private final ProgData progData;
    private final DownloadList downloadList;

    public DownloadListStartFactory(ProgData progData, DownloadList downloadList) {
        this.progData = progData;
        this.downloadList = downloadList;
    }

    public static DownloadData getRestartDownload() {
        if (!DownloadListStartFactory.getDown(1)) {
            return null;
        }
        for (DownloadData download : ProgData.getInstance().downloadList) {
            if (download.isStateInit() || !download.isStateError() || download.getDownloadStart().getRestartCounter() >= ProgConfig.SYSTEM_PARAMETER_DOWNLOAD_MAX_RESTART.getValue() || DownloadListStartFactory.maxChannelPlay(download, 1)) continue;
            int restarted = download.getDownloadStart().getRestartCounter();
            download.restartDownload();
            ProgData.getInstance().downloadList.startDownloads(download);
            download.getDownloadStart().setRestartCounter(++restarted);
            return download;
        }
        return null;
    }

    public static synchronized DownloadData getNextStart() {
        DownloadData download;
        DownloadData ret = null;
        if (!ProgData.getInstance().downloadList.isEmpty() && DownloadListStartFactory.getDown(ProgConfig.DOWNLOAD_MAX_DOWNLOADS.getValue()) && (download = DownloadListStartFactory.nextStart()) != null && download.isStateStartedWaiting()) {
            ret = download;
        }
        return ret;
    }

    private static DownloadData nextStart() {
        DownloadData tmpDownload = DownloadListStartFactory.searchNextDownload(1);
        if (tmpDownload != null) {
            return tmpDownload;
        }
        if (ProgConfig.DOWNLOAD_MAX_ONE_PER_SERVER.getValue().booleanValue()) {
            return null;
        }
        tmpDownload = DownloadListStartFactory.searchNextDownload(2);
        return tmpDownload;
    }

    private static DownloadData searchNextDownload(int maxProChannel) {
        DownloadData tmpDownload = null;
        int nr = -1;
        for (DownloadData download : ProgData.getInstance().downloadList) {
            if (!download.isStateStartedWaiting() || DownloadListStartFactory.maxChannelPlay(download, maxProChannel) || nr != -1 && download.getNo() >= nr) continue;
            tmpDownload = download;
            nr = tmpDownload.getNo();
        }
        return tmpDownload;
    }

    private static boolean maxChannelPlay(DownloadData d, int max) {
        try {
            int counter = 0;
            String host = DownloadListStartFactory.getHost(d);
            if (host.equals("akamaihd.net")) {
                return false;
            }
            for (DownloadData download : ProgData.getInstance().downloadList) {
                if (!download.isStateStartedRun() || !DownloadListStartFactory.getHost(download).equalsIgnoreCase(host) || ++counter < max) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHost(DownloadData download) {
        Object host = "";
        try {
            try {
                URL url;
                String tmp;
                String uurl = download.getEpisodeUrl();
                if (uurl.startsWith("rtmpt:")) {
                    uurl = uurl.toLowerCase().replace("rtmpt:", "http:");
                }
                if (uurl.startsWith("rtmp:")) {
                    uurl = uurl.toLowerCase().replace("rtmp:", "http:");
                }
                if (uurl.startsWith("mms:")) {
                    uurl = uurl.toLowerCase().replace("mms:", "http:");
                }
                if ((tmp = (url = new URL(uurl)).getHost()).contains(".")) {
                    host = tmp.substring(tmp.lastIndexOf(46));
                    host = (tmp = tmp.substring(0, tmp.lastIndexOf(46))).contains(".") ? tmp.substring(tmp.lastIndexOf(46) + 1) + (String)host : (tmp.contains("/") ? tmp.substring(tmp.lastIndexOf(47) + 1) + (String)host : "host");
                }
            }
            catch (Exception ex) {
                host = "host";
            }
            finally {
                if (((String)host).isEmpty()) {
                    host = "host";
                }
            }
        }
        catch (Exception ex) {
            host = "exception";
        }
        return host;
    }

    private static boolean getDown(int max) {
        int count = 0;
        try {
            for (DownloadData download : ProgData.getInstance().downloadList) {
                if (!download.isStateStartedRun() || ++count < max) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            P2Log.errorLog(794519083, ex);
            return false;
        }
    }
}

