/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder;

import de.p2tools.p2lib.guitools.P2Open;
import de.p2tools.p2lib.tools.log.P2Logger;
import de.p2tools.p2lib.tools.shortcut.P2ShortcutWorker;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.ProgQuitFactory;
import de.p2tools.p2podder.controller.config.PShortCut;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.gui.configdialog.ConfigDialogController;
import de.p2tools.p2podder.gui.dialog.AboutDialogController;
import de.p2tools.p2podder.gui.dialog.ResetDialogController;
import de.p2tools.p2podder.tools.update.SearchProgramUpdate;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;

public class ProgMenu
extends MenuButton {
    public ProgMenu() {
        this.makeMenu();
        this.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                ProgConfig.SYSTEM_DARK_THEME.setValue(ProgConfig.SYSTEM_DARK_THEME.getValue() == false);
            }
        });
    }

    private void makeMenu() {
        ProgData progData = ProgData.getInstance();
        MenuItem miConfig = new MenuItem("Einstellungen des Programms");
        miConfig.setOnAction(e -> new ConfigDialogController(progData));
        CheckMenuItem miDarkMode = new CheckMenuItem("Dark Mode");
        miDarkMode.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_DARK_THEME);
        MenuItem miQuit = new MenuItem("Beenden");
        miQuit.setOnAction(e -> ProgQuitFactory.quit());
        P2ShortcutWorker.addShortCut(miQuit, PShortCut.SHORTCUT_QUIT_PROGRAM);
        MenuItem miAbout = new MenuItem("\u00dcber dieses Programm");
        miAbout.setOnAction(event -> new AboutDialogController(progData).showDialog());
        MenuItem miLog = new MenuItem("Logdatei \u00f6ffnen");
        miLog.setOnAction(event -> P2Logger.openLogFile());
        MenuItem miUrlHelp = new MenuItem("Anleitung im Web");
        miUrlHelp.setOnAction(event -> P2Open.openURL("https://www.p2tools.de/p2podder/manual/", ProgConfig.SYSTEM_PROG_OPEN_URL, ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView()));
        MenuItem miReset = new MenuItem("Einstellungen zur\u00fccksetzen");
        miReset.setOnAction(event -> new ResetDialogController(progData));
        MenuItem miSearchUpdate = new MenuItem("Gibt's ein Update?");
        miSearchUpdate.setOnAction(a -> new SearchProgramUpdate(progData).searchNewProgramVersion(true));
        Menu mHelp = new Menu("Hilfe");
        mHelp.getItems().addAll((MenuItem[])new MenuItem[]{miUrlHelp, miLog, miReset, miSearchUpdate, new SeparatorMenuItem(), miAbout});
        if (ProgData.debug) {
            MenuItem miSave = new MenuItem("Alles Speichern");
            miSave.setOnAction(a -> ProgQuitFactory.saveAll());
            MenuItem miSearchAllUpdate = new MenuItem("Alle Programm-Downloads anzeigen");
            miSearchAllUpdate.setOnAction(a -> new SearchProgramUpdate(progData).searchNewProgramVersion(true, true));
            MenuItem miResetTodayDone = new MenuItem("Datum \"heute schon gemacht\" zur\u00fccksetzen");
            miResetTodayDone.setOnAction(a -> ProgConfig.SYSTEM_SEARCH_UPDATE_TODAY_DONE.set("2020.01.01"));
            MenuItem miResetLastSearch = new MenuItem("Datum \"letzte Suche\" zur\u00fccksetzen");
            miResetLastSearch.setOnAction(a -> ProgConfig.SYSTEM_SEARCH_UPDATE_LAST_DATE.set("2020.01.01"));
            mHelp.getItems().addAll((MenuItem[])new MenuItem[]{new SeparatorMenuItem(), miSave, miSearchAllUpdate, miResetTodayDone, miResetLastSearch});
        }
        this.setTooltip(new Tooltip("Programmeinstellungen anzeigen"));
        this.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-1"});
        this.setGraphic(ProgIcons.ICON_TOOLBAR_MENU_TOP.getImageView());
        this.getItems().addAll((MenuItem[])new MenuItem[]{miConfig, miDarkMode, mHelp, new SeparatorMenuItem(), miQuit});
    }
}

