/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.log;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2Open;
import de.p2tools.p2lib.tools.log.P2Formatter;
import de.p2tools.p2lib.tools.log.P2Level;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;

public class P2Logger {
    private static final Logger LOGGER = Logger.getLogger(P2Logger.class.getName());
    private static Handler fileHandler = null;
    private static String handlerDir = "";

    public static void LogInfo(String info) {
        LOGGER.info(info);
    }

    public static void LogDebug(String info) {
        LOGGER.log(P2Level.DEBUG, info);
    }

    public static void LogDuration(String info) {
        LOGGER.log(P2Level.DURATION, info);
    }

    public static void LogExtToolMsg(String info) {
        LOGGER.log(P2Level.EXT_TOOL_MSG, info);
    }

    public static void LogWarning(String info) {
        LOGGER.warning(info);
    }

    public static void LogSevere(String info) {
        LOGGER.log(Level.SEVERE, info);
    }

    public static void LogSevere(String info, Exception ex) {
        LOGGER.log(Level.SEVERE, info, ex);
    }

    public static void LogSevere(Exception ex) {
        LOGGER.log(Level.SEVERE, "", ex);
    }

    public static void removeFileHandler() {
        if (fileHandler != null) {
            P2Log.sysLog("kein Logfile anlegen und handler schlie\u00dfen");
            fileHandler.close();
            LOGGER.removeHandler(fileHandler);
            fileHandler = null;
        }
    }

    public static void openLogFile() {
        if (handlerDir.isEmpty()) {
            return;
        }
        Path path = Paths.get(handlerDir, P2LibConst.logFile_0);
        if (path.toFile().exists()) {
            P2Open.openFile(path.toString());
        } else {
            P2Open.openDir(handlerDir);
        }
    }

    public static void setFileHandler(String path) {
        P2Logger.setFileHandler(path, true);
    }

    public static void setFileHandler(String path, boolean withGui) {
        block3: {
            String logDir;
            String string = logDir = path.isEmpty() ? P2LibConst.logDir : path;
            if (handlerDir.equals(logDir) && fileHandler != null) {
                return;
            }
            P2Logger.removeFileHandler();
            handlerDir = logDir;
            P2Log.sysLog("Logfile anlegen: " + handlerDir);
            try {
                File dir = new File(handlerDir);
                dir.mkdirs();
                fileHandler = new FileHandler(handlerDir + File.separator + P2LibConst.logFile, 5000000, 5, false);
                LOGGER.addHandler(fileHandler);
                fileHandler.setLevel(Level.ALL);
                fileHandler.setFormatter(new P2Formatter());
            }
            catch (IOException exception) {
                LOGGER.log(Level.SEVERE, "Error occur in FileHandler.", exception);
                if (!withGui) break block3;
                Platform.runLater(() -> P2Alert.showErrorAlert("Logfile anlegen", "Das Logfile kann icht angelegt werden, bitte Pfad zum Logfile pr\u00fcfen."));
            }
        }
    }

    static {
        LOGGER.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        LOGGER.addHandler(consoleHandler);
        consoleHandler.setLevel(Level.ALL);
        consoleHandler.setFormatter(new P2Formatter());
        LOGGER.setLevel(Level.ALL);
    }
}

