/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.file;

import de.p2tools.p2lib.tools.file.P2FileUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class P2FileName {
    private static final String STR = "__";
    private static final FastDateFormat FORMATTER_PRE_ddMMyyyyHHmmss = FastDateFormat.getInstance("yyyyMMdd_HHmmss__");
    private static final FastDateFormat FORMATTER_PRE_ddMMyyyyHHmm = FastDateFormat.getInstance("yyyyMMdd_HHmm__");
    private static final FastDateFormat FORMATTER_PRE_ddMMyyyy = FastDateFormat.getInstance("yyyyMMdd__");
    private static final FastDateFormat FORMATTER_ddMMyyyyHHmmss = FastDateFormat.getInstance("__yyyyMMdd_HHmmss");
    private static final FastDateFormat FORMATTER_ddMMyyyyHHmm = FastDateFormat.getInstance("__yyyyMMdd_HHmm");
    private static final FastDateFormat FORMATTER_ddMMyyyy = FastDateFormat.getInstance("__yyyyMMdd");

    public static String getNextFileNameWithNo(String path, String selName, String suff) {
        Path dir = Paths.get(path, new String[0]);
        if (!Files.exists(dir, new LinkOption[0])) {
            return selName;
        }
        if (suff.startsWith(".")) {
            suff = suff.replaceFirst(".", "");
        }
        String name = selName + "." + suff;
        Path baseDirectoryPath = Paths.get(path, name);
        int no = 1;
        while (Files.exists(baseDirectoryPath, new LinkOption[0])) {
            name = selName + STR + no + "." + suff;
            baseDirectoryPath = Paths.get(path, name);
            ++no;
        }
        String ret = baseDirectoryPath.getFileName().toString();
        return ret;
    }

    public static String getNextFileNameWithDate(String name, String suffix, boolean second) {
        if (name.isEmpty()) {
            Object dotSuffix = suffix.startsWith(".") ? suffix : "." + suffix;
            name = System.getProperty("user.home");
            name = P2FileUtils.addsPath(name, "Infos" + (String)dotSuffix);
        }
        String onlyName = FilenameUtils.getName(name);
        String onlyPath = FilenameUtils.getFullPath(name);
        return P2FileName.getNextFileNameWithDate(onlyPath, onlyName, suffix, second);
    }

    public static String getNextFileNameWithDate(String onlyPath, String onlyFileName, String suffix, boolean second) {
        Object ret;
        if (onlyPath == null || onlyFileName == null || suffix == null) {
            return "";
        }
        Object dotSuffix = suffix.startsWith(".") ? suffix : "." + suffix;
        onlyFileName = P2FileUtils.getFileName(onlyFileName);
        String filenameNoSuffix = P2FileName.cleanName(onlyFileName, (String)dotSuffix);
        String date1_pre = FORMATTER_PRE_ddMMyyyy.format(new Date());
        String date2_pre = second ? FORMATTER_PRE_ddMMyyyyHHmmss.format(new Date()) : FORMATTER_PRE_ddMMyyyyHHmm.format(new Date());
        String date1 = FORMATTER_ddMMyyyy.format(new Date());
        String date2 = second ? FORMATTER_ddMMyyyyHHmmss.format(new Date()) : FORMATTER_ddMMyyyyHHmm.format(new Date());
        String containDatePre1 = P2FileName.getDateString(filenameNoSuffix, FORMATTER_PRE_ddMMyyyy);
        String containDatePre2 = second ? P2FileName.getDateString(filenameNoSuffix, FORMATTER_PRE_ddMMyyyyHHmmss) : P2FileName.getDateString(filenameNoSuffix, FORMATTER_PRE_ddMMyyyyHHmm);
        String containDate1 = P2FileName.getDateString(filenameNoSuffix, FORMATTER_ddMMyyyy);
        String containDate2 = second ? P2FileName.getDateString(filenameNoSuffix, FORMATTER_ddMMyyyyHHmmss) : P2FileName.getDateString(filenameNoSuffix, FORMATTER_ddMMyyyyHHmm);
        if (!onlyFileName.endsWith((String)dotSuffix)) {
            String ret2 = P2FileUtils.addsPath(onlyPath, filenameNoSuffix + (String)dotSuffix);
            return ret2;
        }
        if (!containDatePre1.isEmpty()) {
            ret = filenameNoSuffix.replace(containDatePre1, "");
            ret = (String)ret + date1;
        } else if (!containDate1.isEmpty()) {
            ret = filenameNoSuffix.replace(containDate1, "");
            ret = date2_pre + (String)ret;
        } else if (!containDatePre2.isEmpty()) {
            ret = filenameNoSuffix.replace(containDatePre2, "");
            ret = (String)ret + date2;
        } else {
            ret = !containDate2.isEmpty() ? filenameNoSuffix.replace(containDate2, "") : date1_pre + filenameNoSuffix;
        }
        ret = (String)ret + (String)dotSuffix;
        ret = P2FileUtils.addsPath(onlyPath, (String)ret);
        return ret;
    }

    public static String getNextFileNameWithDateWithOutPath(String onlyFileName, String suffix) {
        Object ret;
        if (onlyFileName == null || suffix == null) {
            return "";
        }
        Object dotSuffix = suffix.startsWith(".") ? suffix : "." + suffix;
        onlyFileName = P2FileUtils.getFileName(onlyFileName);
        String filenameNoSuffix = P2FileName.cleanName(onlyFileName, (String)dotSuffix);
        String date1_pre = FORMATTER_PRE_ddMMyyyy.format(new Date());
        String date2_pre = FORMATTER_PRE_ddMMyyyyHHmmss.format(new Date());
        String date1 = FORMATTER_ddMMyyyy.format(new Date());
        String date2 = FORMATTER_ddMMyyyyHHmmss.format(new Date());
        String containDatePre1 = P2FileName.getDateString(filenameNoSuffix, FORMATTER_PRE_ddMMyyyy);
        String containDatePre2 = P2FileName.getDateString(filenameNoSuffix, FORMATTER_PRE_ddMMyyyyHHmmss);
        String containDate1 = P2FileName.getDateString(filenameNoSuffix, FORMATTER_ddMMyyyy);
        String containDate2 = P2FileName.getDateString(filenameNoSuffix, FORMATTER_ddMMyyyyHHmmss);
        if (!onlyFileName.endsWith((String)dotSuffix)) {
            String ret2 = filenameNoSuffix + (String)dotSuffix;
            return ret2;
        }
        if (!containDatePre1.isEmpty()) {
            ret = filenameNoSuffix.replace(containDatePre1, "");
            ret = (String)ret + date1;
        } else if (!containDate1.isEmpty()) {
            ret = filenameNoSuffix.replace(containDate1, "");
            ret = date2_pre + (String)ret;
        } else if (!containDatePre2.isEmpty()) {
            ret = filenameNoSuffix.replace(containDatePre2, "");
            ret = (String)ret + date2;
        } else {
            ret = !containDate2.isEmpty() ? filenameNoSuffix.replace(containDate2, "") : date1_pre + filenameNoSuffix;
        }
        ret = (String)ret + (String)dotSuffix;
        return ret;
    }

    private static String removeCounter(String name) {
        return name.replaceAll("__[0-9]{1,5}\\.", ".");
    }

    private static String cleanName(String name, String suffix) {
        return FilenameUtils.removeExtension(name);
    }

    private static String getDateString(String name, FastDateFormat format) {
        String ret = "";
        Date d = null;
        if (!name.contains(STR)) {
            return "";
        }
        try {
            ret = name.substring(name.lastIndexOf(STR));
            d = new Date(format.parse(ret).getTime());
        }
        catch (Exception ignore) {
            d = null;
        }
        if (d != null && format.getPattern().length() == ret.length()) {
            return ret;
        }
        try {
            ret = name.substring(0, name.indexOf(STR) + STR.length());
            d = new Date(format.parse(ret).getTime());
        }
        catch (Exception ignore) {
            d = null;
        }
        if (d != null && format.getPattern().length() == ret.length()) {
            return ret;
        }
        return "";
    }

    public static String getFilenameRelative(File file, String relative) {
        if (file == null) {
            return "";
        }
        String rel = file.toString();
        if (rel.startsWith(relative) && (rel = rel.replaceFirst(relative, "")).startsWith(File.separator)) {
            rel = rel.replaceFirst(File.separator, "");
        }
        return rel;
    }
}

