/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.date;

import de.p2tools.p2lib.tools.date.P2Date;
import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.log.P2Log;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class P2LDateFactory {
    private P2LDateFactory() {
    }

    public static String getDateTime(LocalDate localDate, DateTimeFormatter format) {
        return localDate == null ? "" : localDate.format(format);
    }

    public static int getYearIntFromString(String year) {
        int ret;
        try {
            ret = Integer.parseInt(year);
        }
        catch (Exception ex) {
            ret = 0;
            P2Log.errorLog(980214963, "Jahr: " + year);
        }
        return ret;
    }

    public static List<String> getYearListSince(String year) {
        ArrayList<String> list = new ArrayList<String>();
        int aktYear = P2LDateFactory.getActYearInt();
        int startCheckYear = P2LDateFactory.getYearIntFromString(year);
        if (startCheckYear <= 0 || aktYear < startCheckYear) {
            return list;
        }
        while (startCheckYear <= aktYear) {
            list.add("" + startCheckYear);
            ++startCheckYear;
        }
        return list;
    }

    public static List<Integer> getYearListSince(int year) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int aktYear = P2LDateFactory.getActYearInt();
        int startCheckYear = P2LDateFactory.getYearIntFromString("" + year);
        if (startCheckYear <= 0 || aktYear < startCheckYear) {
            return list;
        }
        while (startCheckYear <= aktYear) {
            list.add(startCheckYear);
            ++startCheckYear;
        }
        return list;
    }

    public static String getDate_yMd(String d) {
        try {
            LocalDate localDate = LocalDate.parse(d, P2DateConst.DT_FORMATTER_yyyy_MM_dd);
            if (localDate != null) {
                return localDate.format(P2DateConst.DT_FORMATTER_dd_MM_yyyy);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public static LocalDate getNewLocalDate(LocalDate localDate) {
        return LocalDate.of(localDate.getYear(), localDate.getMonth(), localDate.getDayOfMonth());
    }

    public static P2Date getPDate(LocalDate localDate) {
        try {
            P2Date pd = new P2Date();
            pd.setPDate(P2LDateFactory.getDateTime(localDate, P2DateConst.DT_FORMATTER_dd_MM_yyyy));
            return pd;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getYear(LocalDate localDate) {
        if (localDate == null) {
            return "";
        }
        return localDate.format(P2DateConst.DT_FORMATTER_yyyy);
    }

    public static int getActYearInt() {
        return LocalDate.now().getYear();
    }

    public static void setPLocalDateBeforeDay(LocalDate localDate) {
        localDate = localDate.minusDays(1L);
    }

    public static void setPLocalDateNextDay(LocalDate localDate) {
        localDate = localDate.plusDays(1L);
    }

    public static void setPLocalDateNextDay(LocalDate localDate, int days) {
        localDate = localDate.plusDays(days);
    }

    public static LocalDate fromString(String strDate) {
        return P2LDateFactory.fromString(strDate, false);
    }

    public static LocalDate fromString(String strDate, boolean now) {
        try {
            if (strDate.isEmpty()) {
                return LocalDate.MIN;
            }
            return LocalDate.parse(strDate, P2DateConst.DT_FORMATTER_dd_MM_yyyy);
        }
        catch (Exception ex) {
            if (now) {
                return LocalDate.now();
            }
            return LocalDate.MIN;
        }
    }

    public static LocalDate fromStringR(String strDate) {
        return P2LDateFactory.fromStringR(strDate, false);
    }

    public static LocalDate fromStringR(String strDate, boolean now) {
        try {
            if (strDate.isEmpty()) {
                return LocalDate.MIN;
            }
            return LocalDate.parse(strDate, P2DateConst.DT_FORMATTER_yyyy_MM_dd);
        }
        catch (Exception ex) {
            if (now) {
                return LocalDate.now();
            }
            return LocalDate.MIN;
        }
    }

    public static String toString(LocalDate localDate) {
        if (localDate == null) {
            return "";
        }
        if (localDate.isEqual(LocalDate.MIN)) {
            return "";
        }
        return localDate.format(P2DateConst.DT_FORMATTER_dd_MM_yyyy);
    }

    public static String toStringR(LocalDate localDate) {
        if (localDate == null) {
            return "";
        }
        if (localDate.isEqual(LocalDate.MIN)) {
            return "";
        }
        return localDate.format(P2DateConst.DT_FORMATTER_yyyy_MM_dd);
    }

    public static String toStringYYYYMMdd(LocalDate localDate) {
        if (localDate == null) {
            return "";
        }
        if (localDate.isEqual(LocalDate.MIN)) {
            return "";
        }
        return localDate.format(P2DateConst.DT_FORMATTER_yyyyMMdd);
    }

    public static String getNowString() {
        return LocalDate.now().format(P2DateConst.DT_FORMATTER_dd_MM_yyyy);
    }

    public static String getNowStringR() {
        return LocalDate.now().format(P2DateConst.DT_FORMATTER_yyyy_MM_dd);
    }
}

