/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.date;

import de.p2tools.p2lib.tools.date.P2Date;
import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.date.P2DateFactory;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.Date;
import javafx.beans.property.SimpleObjectProperty;
import org.apache.commons.lang3.time.FastDateFormat;

public class P2DateProperty
extends SimpleObjectProperty<P2Date> {
    public P2DateProperty() {
        this.setValue(new P2Date());
    }

    public P2DateProperty(P2Date p2Date) {
        this.setValue(p2Date);
    }

    public P2DateProperty(long l) {
        this.setValue(new P2Date(l));
    }

    public P2DateProperty(String date) {
        this.setPDate(date);
    }

    public P2DateProperty(String date, String time) {
        this.setPDate(date, time);
    }

    public void setPDate(String strDate) {
        this.setPDate(strDate, "");
    }

    public void setPDate(String strDate, String strTime) {
        P2Date p2Date = new P2Date();
        p2Date.setPDate(strDate, strTime);
        this.setValue(p2Date);
    }

    public void clearPDate() {
        this.setValue(new P2Date(0L));
    }

    public void setPDateToday() {
        try {
            String strToday = new P2Date().getDateTime(P2DateConst.F_FORMAT_dd_MM_yyyy);
            long lToday = P2DateConst.F_FORMAT_dd_MM_yyyy.parse(strToday).getTime();
            this.setValue(new P2Date(lToday));
        }
        catch (Exception ex) {
            this.setValue(new P2Date(0L));
            P2Log.errorLog(915263630, ex);
        }
    }

    public void setPDateNow() {
        this.setValue(new P2Date());
    }

    public String getDateTime(FastDateFormat format) {
        if (((P2Date)this.getValue()).getTime() == 0L) {
            return "";
        }
        return format.format((Date)this.getValue());
    }

    public long diffInSeconds() {
        return ((P2Date)this.getValue()).diffInSeconds();
    }

    public long diffInMinutes() {
        return this.diffInSeconds() / 60L;
    }

    @Override
    public String toString() {
        return P2DateFactory.toString((P2Date)this.getValue());
    }
}

