/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools;

import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import javafx.application.Platform;

public class P2Lock {
    public static boolean getLockInstance(String lockFile) {
        boolean exit = false;
        try {
            File file = new File(lockFile);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            FileLock fileLock = randomAccessFile.getChannel().tryLock();
            if (fileLock == null) {
                P2Log.sysLog("PLock: Das Programm l\u00e4uft bereits");
                exit = P2Lock.ask(file);
            } else {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        fileLock.release();
                        randomAccessFile.close();
                        file.delete();
                    }
                    catch (Exception e) {
                        P2Log.errorLog(956230478, e, "Unable to remove lock file: " + lockFile);
                    }
                }));
            }
        }
        catch (Exception e) {
            P2Log.errorLog(784512965, e, "Unable to create and/or lock file: " + lockFile);
        }
        if (exit) {
            P2Lock.exitProg();
            return false;
        }
        return true;
    }

    private static boolean ask(File file) {
        boolean exit;
        P2Alert.BUTTON btn = P2Alert.showAlert_yes_no(null, "Programm starten", "Es l\u00e4uft schon eine Instanz", "Das Programm l\u00e4uft bereits, soll es nochmal gestartet werden?");
        boolean bl = exit = btn == P2Alert.BUTTON.NO;
        if (exit) {
            P2Log.sysLog("PLock: Das Programm l\u00e4uft bereits - nicht nochmal starten");
        } else {
            P2Log.sysLog("PLock: Das Programm l\u00e4uft bereits - nochmal starten");
            try {
                file.delete();
            }
            catch (Exception e) {
                P2Log.errorLog(963569896, e, "Unable to delete the lock file: " + String.valueOf(file));
            }
        }
        return exit;
    }

    private static void exitProg() {
        Platform.runLater(() -> {
            Platform.exit();
            System.exit(0);
        });
    }
}

