/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools;

import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2lib.tools.file.P2FileUtils;
import de.p2tools.p2lib.tools.log.P2Log;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.apache.commons.lang3.SystemUtils;

public class P2InfoFactory {
    private static final String VERSION = "version";

    public static String getStandardDownloadPath() {
        return P2FileUtils.addsPath(P2InfoFactory.getHomePath(), "Downloads");
    }

    public static String getHomePath() {
        return System.getProperty("user.home");
    }

    public static OperatingSystemType getOs() {
        OperatingSystemType os = OperatingSystemType.UNKNOWN;
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            if (System.getenv("ProgramFiles(x86)") != null) {
                os = OperatingSystemType.WIN64;
            } else if (System.getenv("ProgramFiles") != null) {
                os = OperatingSystemType.WIN32;
            }
        } else if (SystemUtils.IS_OS_LINUX) {
            os = OperatingSystemType.LINUX;
        } else if (System.getProperty("os.name").toLowerCase().contains("freebsd")) {
            os = OperatingSystemType.LINUX;
        } else if (SystemUtils.IS_OS_MAC_OSX) {
            os = OperatingSystemType.MAC;
        }
        return os;
    }

    public static String getOsString() {
        return P2InfoFactory.getOs().toString();
    }

    public static String getProgVersionString() {
        return " [Vers.: " + P2InfoFactory.getProgVersion() + " - " + P2InfoFactory.getBuildNo() + " ]";
    }

    public static String[] getJavaVersion() {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        list.add((CallSite)((Object)("Vendor:  " + System.getProperty("java.vendor"))));
        list.add((CallSite)((Object)("VM-Name: " + System.getProperty("java.vm.name"))));
        list.add((CallSite)((Object)("Version: " + System.getProperty("java.version"))));
        list.add((CallSite)((Object)("         Feature: " + Runtime.version().feature() + "  Interim: " + Runtime.version().interim() + "  Update: " + Runtime.version().update() + "  Patch: " + Runtime.version().patch())));
        list.add((CallSite)((Object)("         Runtimeversion: " + System.getProperty("java.runtime.version"))));
        list.add((CallSite)((Object)("JavaFX:  " + System.getProperty("javafx.runtime.version"))));
        return list.toArray(new String[0]);
    }

    public static String getBuildDate() {
        String propToken = "DATE";
        String msg = "";
        try {
            ResourceBundle.clearCache();
            ResourceBundle rb = ResourceBundle.getBundle(VERSION);
            if (rb.containsKey("DATE")) {
                msg = rb.getString("DATE");
                msg = P2LDateFactory.toString(P2LDateFactory.fromStringR(msg));
            }
        }
        catch (Exception e) {
            P2Log.errorLog(807293847, e);
        }
        return msg;
    }

    public static String getBuildDateR() {
        String propToken = "DATE";
        String msg = "";
        try {
            ResourceBundle.clearCache();
            ResourceBundle rb = ResourceBundle.getBundle(VERSION);
            if (rb.containsKey("DATE")) {
                msg = rb.getString("DATE");
            }
        }
        catch (Exception e) {
            P2Log.errorLog(807293847, e);
        }
        return msg;
    }

    public static String getProgVersion() {
        String TOKEN_VERSION = "VERSION";
        try {
            ResourceBundle.clearCache();
            ResourceBundle rb = ResourceBundle.getBundle(VERSION);
            if (rb.containsKey("VERSION")) {
                return rb.getString("VERSION");
            }
        }
        catch (Exception e) {
            P2Log.errorLog(936251478, e);
        }
        return "";
    }

    public static int getProgVersionInt() {
        try {
            return Integer.parseInt(P2InfoFactory.getProgVersion());
        }
        catch (Exception e) {
            P2Log.errorLog(951203647, e);
            return 0;
        }
    }

    public static String getBuildNo() {
        String TOKEN_VERSION = "BUILD";
        try {
            ResourceBundle.clearCache();
            ResourceBundle rb = ResourceBundle.getBundle(VERSION);
            if (rb.containsKey("BUILD")) {
                return rb.getString("BUILD");
            }
        }
        catch (Exception e) {
            P2Log.errorLog(987012549, e);
        }
        return "0";
    }

    public static int getBuildNoInt() {
        try {
            return Integer.parseInt(P2InfoFactory.getBuildNo());
        }
        catch (Exception e) {
            P2Log.errorLog(951203647, e);
            return 0;
        }
    }

    public static enum OperatingSystemType {
        UNKNOWN(""),
        WIN("Windows"),
        WIN32("Windows"),
        WIN64("Windows"),
        LINUX("Linux"),
        MAC("Mac");

        private final String name;

        private OperatingSystemType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

