/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools;

import de.p2tools.p2lib.tools.log.P2Log;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public class GermanStringIntSorter
implements Comparator<String> {
    private static Collator collator;
    private static GermanStringIntSorter instance;

    public GermanStringIntSorter() {
        collator = Collator.getInstance(Locale.GERMANY);
        collator.setStrength(1);
    }

    public static GermanStringIntSorter getInstance() {
        if (instance == null) {
            instance = new GermanStringIntSorter();
        }
        return instance;
    }

    @Override
    public int compare(String o1, String o2) {
        try {
            if (o1 != null && o2 != null) {
                o1 = o1.toLowerCase(Locale.GERMANY);
                o2 = o2.toLowerCase(Locale.GERMANY);
                int l1 = o1.length();
                int l2 = o2.length();
                int count1 = 0;
                int count2 = 0;
                Object digit = "";
                for (int i = 0; i < o1.length() && i < o2.length(); ++i) {
                    if (count1 >= l1 && count2 < l2) {
                        return -1;
                    }
                    if (count1 < l1 && count2 >= l2) {
                        return 1;
                    }
                    if (count1 >= l1 && count2 >= l2) break;
                    char c1 = o1.charAt(count1);
                    char c2 = o2.charAt(count2);
                    if (Character.isDigit(c1) && Character.isDigit(c2)) {
                        while (count1 < l1 && Character.isDigit(o1.charAt(count1))) {
                            c1 = o1.charAt(count1);
                            digit = (String)digit + c1;
                            ++count1;
                        }
                        int digit1 = Integer.valueOf((String)digit);
                        digit = "";
                        while (count2 < l2 && Character.isDigit(o2.charAt(count2))) {
                            c2 = o2.charAt(count2);
                            digit = (String)digit + c2;
                            ++count2;
                        }
                        int digit2 = Integer.valueOf((String)digit);
                        digit = "";
                        ++count2;
                        if (digit1 == digit2 && ++count1 >= l1) {
                            return 1;
                        }
                        if (digit1 == digit2 && count2 >= l2) {
                            return -1;
                        }
                        if (digit1 == digit2) continue;
                        int ret = digit1 == digit2 ? 0 : (digit1 < digit2 ? -1 : 1);
                        return ret;
                    }
                    if (c1 == c2) {
                        ++count1;
                        ++count2;
                        continue;
                    }
                    if (!Character.isDigit(c1) && !Character.isDigit(c2)) {
                        return collator.compare(String.valueOf(c1), String.valueOf(c2));
                    }
                    if (Character.isDigit(c1) && !Character.isDigit(c2)) {
                        return -1;
                    }
                    if (Character.isDigit(c1) || !Character.isDigit(c2)) continue;
                    return 1;
                }
                return collator.compare(o1, o2);
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(915247789, ex, new String[]{"GermanStringSorter:", o1, o2});
        }
        return 0;
    }
}

