/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools;

import de.p2tools.p2lib.tools.log.P2Log;
import java.text.Normalizer;
import java.util.regex.Pattern;

public class DiacriticFactory {
    private static final Pattern DIACRITICS_AND_FRIENDS = Pattern.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");

    private DiacriticFactory() {
    }

    public static String flattenDiacritic(String string) {
        try {
            String to = DiacriticFactory.strip(string);
            if (string.equals(to)) {
                return string;
            }
            char[] s = string.toCharArray();
            char[] t = to.toCharArray();
            for (int i = 0; i < s.length; ++i) {
                String st = "" + s[i];
                if (!st.equals("\u00e4") && !st.equals("\u00f6") && !st.equals("\u00fc") && !st.equals("\u00c4") && !st.equals("\u00d6") && !st.equals("\u00dc")) continue;
                t[i] = s[i];
            }
            return String.valueOf(t);
        }
        catch (Exception ex) {
            P2Log.errorLog(987451254, ex);
            return string;
        }
    }

    private static String strip(String str) {
        str = Normalizer.normalize(str, Normalizer.Form.NFD);
        str = DIACRITICS_AND_FRIENDS.matcher(str).replaceAll("");
        return str;
    }
}

