/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.p2event;

import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2Events;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2lib.tools.duration.P2Duration;
import java.util.ArrayList;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.util.Duration;

public class P2EventHandler {
    private final ArrayList<P2Listener> listeners = new ArrayList();
    public static long countRunningTimeSeconds = 0L;
    private boolean oneSecond = false;

    public P2EventHandler() {
        this.startTimer();
    }

    public P2EventHandler(boolean startTimer) {
        if (startTimer) {
            this.startTimer();
        }
    }

    public void addListener(P2Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(P2Listener listener) {
        this.listeners.remove(listener);
    }

    public <T extends P2Event> void notifyListener(T event) {
        this.listeners.stream().filter(p2Listener -> p2Listener.getEventNo() == event.getEventNo()).forEach(p2Listener -> p2Listener.notify(event));
    }

    public void notifyListener(int eventNo) {
        P2Event event = new P2Event(eventNo);
        this.listeners.stream().filter(p2Listener -> p2Listener.getEventNo() == event.getEventNo()).forEach(p2Listener -> p2Listener.notify(event));
    }

    public void startTimer() {
        Timeline timeline = new Timeline(new KeyFrame(Duration.millis(500.0), ae -> {
            boolean bl = this.oneSecond = !this.oneSecond;
            if (this.oneSecond) {
                this.doTimerWorkOneSecond();
            }
            this.doTimerWorkHalfSecond();
        }, new KeyValue[0]));
        timeline.setCycleCount(-1);
        timeline.setDelay(Duration.seconds(5.0));
        timeline.play();
        P2Duration.onlyPing("Timer gestartet");
    }

    private void doTimerWorkOneSecond() {
        ++countRunningTimeSeconds;
        this.notifyListener(P2Events.EVENT_TIMER_SECOND);
    }

    private void doTimerWorkHalfSecond() {
        this.notifyListener(P2Events.EVENT_TIMER_HALF_SECOND);
    }
}

