/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.filmlistload;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.mediathek.film.FilmFactory;
import de.p2tools.p2lib.mediathek.film.P2FilmlistFactory;
import de.p2tools.p2lib.mediathek.filmdata.FilmData;
import de.p2tools.p2lib.mediathek.filmdata.FilmDataProps;
import de.p2tools.p2lib.mediathek.filmdata.Filmlist;
import de.p2tools.p2lib.mediathek.filmlistload.P2ImportFilmlistFromServer;
import de.p2tools.p2lib.mediathek.filmlistload.P2LoadConst;
import de.p2tools.p2lib.mediathek.filmlistload.P2LoadFactory;
import de.p2tools.p2lib.mediathek.filmlistreadwrite.P2ReadFilmlist;
import de.p2tools.p2lib.mediathek.filmlistreadwrite.P2WriteFilmlistJson;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2EventHandler;
import de.p2tools.p2lib.p2event.P2Events;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

public class P2LoadFilmlist {
    public static final double PROGRESS_MIN = 0.0;
    public static final double PROGRESS_MAX = 1.0;
    public static final double PROGRESS_INDETERMINATE = -1.0;
    private final HashSet<String> hashSet;
    private final Filmlist filmListDiff;
    private final Filmlist filmListNew;
    private final P2ImportFilmlistFromServer p2ImportFilmlistFromServer;
    private final P2EventHandler p2EventHandler;
    private final BooleanProperty propLoadFilmlist = new SimpleBooleanProperty(false);
    private boolean filmlistTooOld = false;

    public P2LoadFilmlist(P2EventHandler p2EventHandler) {
        this.p2EventHandler = p2EventHandler;
        this.filmListDiff = new Filmlist();
        this.filmListNew = new Filmlist();
        this.hashSet = new HashSet();
        this.p2ImportFilmlistFromServer = new P2ImportFilmlistFromServer();
    }

    public P2LoadFilmlist(P2EventHandler p2EventHandler, Filmlist<? extends FilmData> filmlistNew, Filmlist<? extends FilmData> filmlistDiff) {
        this.p2EventHandler = p2EventHandler;
        this.filmListDiff = filmlistDiff;
        this.filmListNew = filmlistNew;
        this.hashSet = new HashSet();
        this.p2ImportFilmlistFromServer = new P2ImportFilmlistFromServer();
    }

    public P2EventHandler getP2EventHandler() {
        return this.p2EventHandler;
    }

    public void loadFilmlistProgStart() {
        if (P2LoadFactory.checkAllSenderSelectedNotToLoad(P2LibConst.actStage)) {
            P2Log.sysLog("Filmliste laden: Es sind keine Sender eingeschaltet!!");
            return;
        }
        this.setPropLoadFilmlist(true);
        this.p2EventHandler.notifyListener(new P2Event(P2Events.EVENT_FILMLIST_LOAD_START, "Programmstart, Filmliste laden", -1.0));
        new Thread(() -> {
            ArrayList<String> logList = new ArrayList<String>();
            P2Duration.counterStart("loadFilmlistProgStart");
            logList.add("## ############################################################");
            logList.add("## ############################################################");
            logList.add("## Filmliste laden");
            logList.add("## Filmliste beim **Programmstart** laden - start");
            this.loadFilmlistProgStart(logList);
            this.afterLoading(logList);
            logList.add("## Filmliste beim Programmstart laden - ende");
            logList.add("## ############################################################");
            logList.add("## ############################################################");
            logList.add("");
            P2Log.emptyLine();
            P2Log.sysLog(logList);
            P2Log.emptyLine();
            this.setPropLoadFilmlist(false);
            P2Duration.counterStop("loadFilmlistProgStart");
        }).start();
    }

    public void loadNewFilmlistFromWeb(boolean alwaysLoadNew) {
        if (P2LoadFactory.checkAllSenderSelectedNotToLoad(P2LibConst.actStage)) {
            P2Log.sysLog("Filmliste laden: Es sind keine Sender eingeschaltet!!");
            return;
        }
        this.setPropLoadFilmlist(true);
        this.p2EventHandler.notifyListener(new P2Event(P2Events.EVENT_FILMLIST_LOAD_START, "Filmliste aus dem Web laden", -1.0));
        new Thread(() -> {
            ArrayList<String> logList = new ArrayList<String>();
            P2Duration.counterStart("loadNewFilmlistFromWeb");
            logList.add("## ############################################################");
            logList.add("## ############################################################");
            logList.add("## Filmliste laden");
            logList.add("## Filmliste aus dem Web laden - start");
            logList.add("## Alte Liste erstellt  am: " + P2LoadConst.filmlistLocal.genDate());
            logList.add("##            Anzahl Filme: " + P2LoadConst.filmlistLocal.size());
            logList.add("##            Anzahl  Neue: " + P2LoadConst.filmlistLocal.countNewFilms());
            logList.add("##");
            this.loadNewFilmlistFromWeb(logList, alwaysLoadNew, false, P2LoadConst.localFilmListFile);
            this.afterLoading(logList);
            logList.add("## Filmliste aus dem Web laden - ende");
            logList.add("## ############################################################");
            logList.add("## ############################################################");
            logList.add("");
            P2Log.emptyLine();
            P2Log.sysLog(logList);
            P2Log.emptyLine();
            this.setPropLoadFilmlist(false);
            P2Duration.counterStop("loadNewFilmlistFromWeb");
        }).start();
    }

    public boolean getPropLoadFilmlist() {
        return this.propLoadFilmlist.get();
    }

    public BooleanProperty propLoadFilmlistProperty() {
        return this.propLoadFilmlist;
    }

    public void setPropLoadFilmlist(boolean propLoadFilmlist) {
        this.propLoadFilmlist.set(propLoadFilmlist);
    }

    private void loadFilmlistProgStart(List<String> logList) {
        this.filmListNew.setMeta(P2LoadConst.filmlistLocal);
        this.filmListNew.setAll(P2LoadConst.filmlistLocal);
        if (P2LoadConst.firstProgramStart) {
            logList.add("## Erster Programmstart -> Liste aus dem Web laden");
            this.loadNewFilmlistFromWeb(logList, false, true, P2LoadConst.localFilmListFile);
            P2Duration.onlyPing("Erster Programmstart: Neu Filmliste aus dem Web geladen");
            this.getP2EventHandler().notifyListener(new P2Event(P2Events.EVENT_FILMLIST_LOAD_LOADED, "Filme verarbeiten", -1.0));
            return;
        }
        if (!P2LoadConst.loadNewFilmlistOnProgramStart) {
            logList.add("## Beim Programmstart soll keine neue Liste geladen werden");
            logList.add("## Programmstart: Gespeicherte Liste aus laden");
            P2LoadConst.filmInitNecessary = true;
            this.loadStoredList(logList, this.filmListNew, P2LoadConst.localFilmListFile);
            logList.add("## Programmstart: Gespeicherte Liste aus geladen");
        } else {
            if (P2FilmlistFactory.isTooOld(P2LoadConst.dateStoredFilmlist.getValueSafe())) {
                logList.add("## Gespeicherte Filmliste ist zu alt: " + String.valueOf(P2LoadConst.dateStoredFilmlist));
                this.filmlistTooOld = true;
                if (P2FilmlistFactory.isTooOldForDiff(P2LoadConst.dateStoredFilmlist.getValueSafe())) {
                    logList.add("## Gespeicherte Filmliste zu alt f\u00fcr ein DIFF, kein FILM_INIT");
                    P2LoadConst.filmInitNecessary = false;
                } else {
                    logList.add("## Gespeicherte Filmliste zu alt, DIFF reicht, FILM_INIT wird gemacht");
                    P2LoadConst.filmInitNecessary = true;
                }
            } else {
                logList.add("## Gespeicherte Filmliste ist nicht zu alt: " + String.valueOf(P2LoadConst.dateStoredFilmlist));
                P2LoadConst.filmInitNecessary = true;
            }
            P2Duration.counterStart("loadStoredList");
            logList.add("## Programmstart: Gespeicherte Liste laden");
            this.loadStoredList(logList, this.filmListNew, P2LoadConst.localFilmListFile);
            P2LoadConst.filmInitNecessary = true;
            logList.add("## Programmstart: Gespeicherte Liste geladen");
            P2Log.debugLog("## loadStoredList: " + String.valueOf(P2Duration.counterStop("loadStoredList")));
            if (this.filmListNew.isEmpty()) {
                logList.add("## Gespeicherte Filmliste ist leer, neue Filmliste aus dem Web laden");
                logList.add("## Alter|min]: " + this.filmListNew.getAge() / 60);
                logList.add("## ------------------------------------------------------------");
            }
            if (this.filmlistTooOld || this.filmListNew.isEmpty()) {
                this.filmlistTooOld = false;
                this.p2EventHandler.notifyListener(new P2Event(P2Events.EVENT_FILMLIST_LOAD_PROGRESS, "Filmliste ist zu alt, eine neue laden", -1.0));
                logList.add("## Programmstart: Neue Liste aus dem Web laden");
                this.loadNewFilmlistFromWeb(logList, false, true, P2LoadConst.localFilmListFile);
                P2Duration.onlyPing("Programmstart: Neu Filmliste aus dem Web geladen");
            }
        }
        this.getP2EventHandler().notifyListener(new P2Event(P2Events.EVENT_FILMLIST_LOAD_LOADED, "Filme verarbeiten", -1.0));
    }

    private void afterLoading(List<String> logList) {
        logList.add("##");
        logList.add("## Jetzige Liste erstellt am: " + this.filmListNew.genDate());
        logList.add("##   Anzahl Filme: " + this.filmListNew.size());
        logList.add("##   Anzahl Neue:  " + this.filmListNew.countNewFilms());
        logList.add("##");
        logList.add("## ============================================================");
        logList.add("##");
        this.getP2EventHandler().notifyListener(new P2Event(P2Events.EVENT_FILMLIST_LOAD_LOADED, "Filme markieren, Themen suchen", -1.0));
        logList.add("## Filme markieren");
        int count = this.filmListNew.markFilms(logList);
        logList.add("## Anzahl doppelte Filme: " + count);
        this.filmListNew.loadSender();
        logList.add("## ==> und jetzt die Filmliste wieder f\u00fcllen :)");
        P2LoadConst.filmlistLocal.metaData = this.filmListNew.metaData;
        P2LoadConst.filmlistLocal.sender = this.filmListNew.sender;
        P2LoadConst.filmlistLocal.addAll(this.filmListNew);
        this.filmListNew.clear();
        this.p2EventHandler.notifyListener(new P2Event(P2Events.EVENT_FILMLIST_LOAD_FINISHED));
    }

    private void loadStoredList(List<String> logList, Filmlist filmlist, String localFilmListFile) {
        new P2ReadFilmlist().readFilmlistWebOrLocal(logList, filmlist, localFilmListFile);
    }

    private void loadNewFilmlistFromWeb(List<String> logList, boolean alwaysLoadNew, boolean intern, String localFilmListFile) {
        if (intern) {
            this.fillHash(logList, this.filmListNew);
        } else {
            this.fillHash(logList, P2LoadConst.filmlistLocal);
            this.filmListNew.setMeta(P2LoadConst.filmlistLocal);
            if (!alwaysLoadNew) {
                this.filmListNew.addAll(P2LoadConst.filmlistLocal);
            }
            P2LoadConst.filmlistLocal.clear();
        }
        P2LoadConst.stop.set(false);
        logList.add("## Filmliste laden (auto)");
        boolean wasOk = this.p2ImportFilmlistFromServer.importFilmListFromWebAuto(logList, this.filmListNew, this.filmListDiff);
        if (wasOk) {
            this.afterLoadingNewFilmlistFromServer(logList, localFilmListFile);
        } else {
            logList.add("## ------------------------------------------------------------");
            logList.add("## Das Laden hat nicht geklappt, alte Liste wieder laden");
            P2LoadConst.stop.set(false);
            this.loadStoredList(logList, this.filmListNew, localFilmListFile);
            logList.add("##");
        }
    }

    private void afterLoadingNewFilmlistFromServer(List<String> logList, String localFilmListFile) {
        logList.add("## ------------------------------------------------------------");
        if (!this.filmListDiff.isEmpty()) {
            this.filmListNew.updateList(this.filmListDiff, true, true);
            this.filmListNew.metaData = this.filmListDiff.metaData;
            P2Duration.counterStart("sortNewList");
            this.filmListNew.sort();
            P2Log.debugLog("## Update List, Sort: " + String.valueOf(P2Duration.counterStop("sortNewList")));
            this.filmListDiff.clear();
        }
        logList.add("## Neue Filme markieren");
        this.findAndMarkNewFilms(logList, this.filmListNew);
        P2Duration.counterStart("cleanFaultyCharacter");
        FilmFactory.cleanFaultyCharacterFilmlist(logList, this.filmListNew);
        P2Log.debugLog("## Unicode-Zeichen korrigieren: " + String.valueOf(P2Duration.counterStop("cleanFaultyCharacter")));
        logList.add("## Diakritika setzen/\u00e4ndern, Diakritika suchen");
        if (P2LoadConst.removeDiacritic) {
            FilmFactory.flattenDiacritic(this.filmListNew);
        } else {
            logList.add("## Diakritika: nicht gewollt");
        }
        logList.add("##");
        logList.add("## Filme schreiben (" + this.filmListNew.size() + " Filme) :");
        logList.add("##    --> Start Schreiben nach: " + localFilmListFile);
        new P2WriteFilmlistJson().write(localFilmListFile, this.filmListNew);
        logList.add("##    --> geschrieben!");
        logList.add("##");
    }

    private void fillHash(List<String> logList, Filmlist<? extends FilmData> filmlist) {
        logList.add("## ------------------------------------------------------------");
        logList.add("## Hash f\u00fcllen, Gr\u00f6\u00dfe vorher: " + this.hashSet.size());
        this.hashSet.addAll(filmlist.stream().map(FilmDataProps::getUrlHistory).collect(Collectors.toList()));
        logList.add("##                   nachher: " + this.hashSet.size());
        logList.add("## ------------------------------------------------------------");
    }

    private void findAndMarkNewFilms(List<String> logList, Filmlist<? extends FilmData> filmlist) {
        filmlist.stream().peek(film -> film.setNewFilm(false)).filter(film -> !this.hashSet.contains(film.getUrlHistory())).forEach(film -> film.setNewFilm(true));
        this.hashSet.clear();
    }
}

