/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.audiolistload;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import de.p2tools.p2lib.mediathek.audio.P2AudioListFactory;
import de.p2tools.p2lib.mediathek.audiolistload.P2ReadWebAudioToFilmListJson;
import de.p2tools.p2lib.mediathek.download.MtHttpClient;
import de.p2tools.p2lib.mediathek.film.FilmFactory;
import de.p2tools.p2lib.mediathek.filmdata.FilmData;
import de.p2tools.p2lib.mediathek.filmdata.FilmDataProps;
import de.p2tools.p2lib.mediathek.filmdata.Filmlist;
import de.p2tools.p2lib.mediathek.filmlistload.P2LoadConst;
import de.p2tools.p2lib.mediathek.filmlistload.P2LoadFactory;
import de.p2tools.p2lib.mediathek.filmlistreadwrite.P2WriteFilmlistJson;
import de.p2tools.p2lib.mediathek.tools.P2InputStreamProgressMonitor;
import de.p2tools.p2lib.mediathek.tools.P2ProgressMonitorInputStream;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2Events;
import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.date.P2LDateTimeFactory;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.SimpleTimeZone;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.time.FastDateFormat;

public class P2ReadWebAudioList {
    private final List<String> logList;
    private static int countDouble = 0;
    private HashSet<String> hashSet = new HashSet();
    public Filmlist<FilmData> audioListNew;

    public P2ReadWebAudioList(List<String> logList, Filmlist<FilmData> audioListNew) {
        this.logList = logList;
        this.audioListNew = audioListNew;
    }

    public boolean readWebList(String path) {
        boolean ret;
        P2Duration.counterStart("readWebList");
        try {
            this.hashSet.addAll(P2LoadConst.audioListLocal.stream().map(FilmDataProps::getUrlHistory).toList());
            this.hashSet.addAll(this.audioListNew.stream().map(FilmDataProps::getUrlHistory).toList());
            P2LoadConst.audioListLocal.clear();
            this.audioListNew.clear();
            this.logList.add("## Audioliste aus URL laden: https://atlist.de/audios.xz");
            this.processFromWeb(new URL("https://atlist.de/audios.xz"), this.audioListNew);
            if (this.audioListNew.isEmpty()) {
                ret = false;
            } else {
                this.setDateFromWeb();
                this.flattenDiacritic(this.logList, this.audioListNew);
                this.markNewFilms(this.logList, this.audioListNew);
                this.markDoubleAudios(this.logList, this.audioListNew);
                this.logList.add("##");
                this.logList.add("## Audioliste schreiben (" + this.audioListNew.size() + " Audios) :");
                this.logList.add("##    --> Start Schreiben nach: " + path);
                new P2WriteFilmlistJson().write(path, this.audioListNew);
                this.logList.add("##    --> geschrieben!");
                this.logList.add("##");
                ret = true;
            }
        }
        catch (Exception ex) {
            this.logList.add("##   Audioliste lesen hat nicht geklappt");
            P2Log.errorLog(645891204, ex);
            P2LoadConst.p2EventHandler.notifyListener(new P2Event(P2Events.LOAD_AUDIO_LIST_FINISHED, "Laden hat nicht geklappt", -1.0));
            ret = false;
        }
        P2Duration.counterStop("readWebList");
        return ret;
    }

    private void setDateFromWeb() {
        LocalDateTime date = P2AudioListFactory.getDate(this.audioListNew.metaData);
        String dateStr = P2LDateTimeFactory.toString(date, P2DateConst.DT_FORMATTER__FILMLIST);
        P2LoadConst.dateStoredAudiolist.set(dateStr);
    }

    private void processFromWeb(URL source2, Filmlist<FilmData> audioList) {
        block31: {
            Request.Builder builder = new Request.Builder().url(source2);
            builder.addHeader("User-Agent", P2LoadConst.userAgent);
            P2InputStreamProgressMonitor monitor = new P2InputStreamProgressMonitor(){
                private int oldProgress = 0;

                @Override
                public void progress(long bytesRead, long size) {
                    int iProgress = (int)(bytesRead * 100L / size);
                    if (iProgress != this.oldProgress) {
                        this.oldProgress = iProgress;
                    }
                }
            };
            try (Response response = MtHttpClient.getInstance().getHttpClient().newCall(builder.build()).execute();
                 ResponseBody body = response.body();){
                if (body == null || !response.isSuccessful()) break block31;
                try (P2ProgressMonitorInputStream input = new P2ProgressMonitorInputStream(body.byteStream(), body.contentLength(), monitor);
                     InputStream is = P2LoadFactory.selectDecompressor(source2.toString(), input);
                     JsonParser jp = new JsonFactory().createParser(is);){
                    new P2ReadWebAudioToFilmListJson().readAudioData(jp, audioList);
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(820147395, ex, "FilmListe: " + String.valueOf(source2));
                audioList.clear();
            }
        }
        P2ReadWebAudioList.changeMeta(audioList.metaData);
    }

    private static void changeMeta(String[] metaData) {
        String DATE_TIME_FORMAT_MEDIATHEK = "dd.MM.yyyy, HH:mm";
        String DATE_TIME_FORMAT_AUDIOTHEK = "dd.MM.yyyy HH:mm:ss";
        try {
            SimpleDateFormat sdf_audiothek = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            String date = metaData[1];
            String dateGmt = metaData[0];
            Date filmDate = sdf_audiothek.parse(date);
            Date filmDateGmt = sdf_audiothek.parse(dateGmt);
            metaData[1] = FastDateFormat.getInstance("dd.MM.yyyy, HH:mm").format(filmDateGmt);
            metaData[0] = FastDateFormat.getInstance("dd.MM.yyyy, HH:mm").format(filmDate);
        }
        catch (Exception ex) {
            P2Log.errorLog(965874548, ex, "GenDateTime: Audiolist");
            SimpleDateFormat sdf_mediathek = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
            SimpleDateFormat sdfUtf_mediathek = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
            sdfUtf_mediathek.setTimeZone(new SimpleTimeZone(2, "UTC"));
            String d = sdf_mediathek.format(new Date());
            String dUtf = sdfUtf_mediathek.format(new Date());
            metaData[0] = d;
            metaData[1] = dUtf;
        }
    }

    private void flattenDiacritic(List<String> logList, Filmlist<FilmData> audioList) {
        logList.add("## Diakritika setzen/\u00e4ndern, Diakritika suchen");
        if (P2LoadConst.removeDiacritic) {
            FilmFactory.flattenDiacritic(audioList);
        } else {
            logList.add("## Diakritika: nicht gewollt");
        }
    }

    private void markNewFilms(List<String> logList, Filmlist<FilmData> audioList) {
        logList.add("## neue Audios markieren");
        audioList.stream().peek(film -> film.setNewFilm(false)).filter(film -> !this.hashSet.contains(film.getUrl())).forEach(film -> film.setNewFilm(true));
        this.hashSet.clear();
    }

    public void markDoubleAudios(List<String> logList, Filmlist<FilmData> audioList) {
        P2Duration.counterStart("markDoubleAudios");
        logList.add("## doppelte Audios markieren");
        HashSet urlHashSet = new HashSet(audioList.size(), 0.75f);
        countDouble = 0;
        audioList.forEach(f -> {
            if (!urlHashSet.add(f.getUrl())) {
                ++countDouble;
                f.setDoubleUrl(true);
            }
        });
        urlHashSet.clear();
        logList.add("## Anzahl doppelte: " + countDouble);
        if (P2LoadConst.SYSTEM_FILMLIST_REMOVE_DOUBLE) {
            logList.add("## und entfernen");
            logList.add("## Anzahl: " + audioList.size());
            audioList.removeIf(FilmDataProps::isDoubleUrl);
            logList.add("## Anzahl jetzt: " + audioList.size());
        }
        P2LoadConst.SYSTEM_AUDIOLIST_COUNT_DOUBLE.setValue(countDouble);
        P2Duration.counterStop("markDoubleAudios");
    }
}

