/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.audiolistload;

import de.p2tools.p2lib.mediathek.film.P2FilmlistFactory;
import de.p2tools.p2lib.mediathek.filmdata.FilmData;
import de.p2tools.p2lib.mediathek.filmdata.Filmlist;
import de.p2tools.p2lib.mediathek.filmlistload.P2LoadConst;
import de.p2tools.p2lib.mediathek.filmlistreadwrite.P2ReadFilmlist;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2Events;
import de.p2tools.p2lib.tools.log.P2Log;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class P2ReadLocalAudioList {
    private final List<String> logList;
    public Filmlist<FilmData> audioListNew;

    public P2ReadLocalAudioList(List<String> logList, Filmlist<FilmData> audioListNew) {
        this.logList = logList;
        this.audioListNew = audioListNew;
    }

    public boolean readLocalList(String path) {
        boolean ret;
        try {
            Path listPath = Paths.get(path, new String[0]);
            if (!Files.exists(listPath, new LinkOption[0]) || listPath.toFile().length() == 0L) {
                return false;
            }
            P2LoadConst.audioListLocal.clear();
            this.audioListNew.clear();
            this.logList.add("## Audioliste lesen");
            this.logList.add("##    --> Lesen von: " + path);
            new P2ReadFilmlist(false).readFilmlistWebOrLocal(this.logList, this.audioListNew, path);
            this.setDateFromLocal();
            this.audioListNew.loadSender();
            this.logList.add("##   Audioliste gelesen, OK");
            this.logList.add("##   Anzahl gelesen: " + this.audioListNew.size());
            ret = true;
        }
        catch (Exception ex) {
            this.logList.add("##   Audioliste lesen hat nicht geklappt");
            P2Log.errorLog(645891204, ex);
            P2LoadConst.p2EventHandler.notifyListener(new P2Event(P2Events.LOAD_AUDIO_LIST_FINISHED, "Laden hat nicht geklappt", -1.0));
            ret = false;
        }
        return ret;
    }

    private void setDateFromLocal() {
        String date = P2FilmlistFactory.genDate(this.audioListNew.metaData);
        P2LoadConst.dateStoredAudiolist.set(date);
    }
}

