/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.audiodata;

import de.p2tools.p2lib.mediathek.audio.P2AudioListFactory;
import de.p2tools.p2lib.mediathek.audiodata.AudioData;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;

public class AudioList
extends SimpleListProperty<AudioData> {
    public static final int AUDIO_LIST_META_MAX_ELEM = 2;
    public static final String AUDIO_LIST_TAG = "AudioList";
    public static int META_GMT = 0;
    public static int META_LOCAL = 1;
    public int nr = 1;
    public String[] metaData = new String[]{"GMT", "LocalDate"};
    public String[] sender = new String[]{""};
    public String[] genre = new String[]{""};
    int count = 0;
    FilteredList<AudioData> filteredList = null;
    SortedList<AudioData> sortedList = null;

    public AudioList() {
        super(FXCollections.observableArrayList());
    }

    public synchronized void setMeta(AudioList filaudioDatalist) {
        System.arraycopy(filaudioDatalist.metaData, 0, this.metaData, 0, 2);
    }

    public SortedList<AudioData> getSortedList() {
        this.initFilterdList();
        return this.sortedList;
    }

    public FilteredList<AudioData> getFilteredList() {
        this.initFilterdList();
        return this.filteredList;
    }

    private void initFilterdList() {
        if (this.sortedList == null || this.filteredList == null) {
            this.filteredList = new FilteredList<AudioData>(this, p -> true);
            this.sortedList = new SortedList<AudioData>((ObservableList<AudioData>)this.filteredList);
        }
    }

    public synchronized void filteredListSetPred(Predicate<AudioData> predicate) {
        P2Log.debugLog("=================> Filter: " + ++this.count);
        P2Duration.counterStart("FilmList.filteredListSetPred");
        this.getFilteredList().setPredicate(predicate);
        P2Duration.counterStop("FilmList.filteredListSetPred");
    }

    public synchronized void importAudioOnlyWithNr(AudioData audioData) {
        audioData.no = this.nr++;
        this.add(audioData);
    }

    @Override
    public synchronized void clear() {
        this.nr = 1;
        super.clear();
    }

    public synchronized void sort() {
        Collections.sort(this);
        int i = 1;
        for (AudioData film : this) {
            film.no = i++;
        }
    }

    public synchronized AudioData getAudioByUrl(String url) {
        Optional<AudioData> opt = this.parallelStream().filter(f -> f.arr[12].equalsIgnoreCase(url)).findAny();
        return opt.orElse(null);
    }

    public synchronized void getTheme(String sender, LinkedList<String> list) {
        this.stream().filter(film -> film.arr[1].equals(sender)).filter(film -> !list.contains(film.arr[3])).forEach(film -> list.add(film.arr[3]));
    }

    public synchronized void loadSenderAndGenre() {
        P2Duration.counterStart("loadSenderAndGenre");
        LinkedHashSet<String> setSender = new LinkedHashSet<String>(21);
        setSender.add("");
        this.forEach(audioData -> setSender.add(audioData.getChannel()));
        this.sender = setSender.toArray(new String[0]);
        LinkedHashSet<String> setGenre = new LinkedHashSet<String>(15);
        setGenre.add("");
        this.forEach(audioData -> setGenre.add(audioData.getGenre()));
        this.genre = setGenre.toArray(new String[0]);
        P2Duration.counterStop("loadSenderAndGenre");
    }

    public int getAge() {
        return P2AudioListFactory.getAge(this.metaData);
    }
}

